/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.ConfigTestEnum;
import fi.dy.masa.malilib.test.TestInventoryOverlayHandler;
import fi.dy.masa.malilib.test.TestWalls;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Experimental
public class TestRenderHandler
implements IRenderer {
    private static final TestRenderHandler INSTANCE = new TestRenderHandler();

    public static TestRenderHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void onRenderGameOverlayLastDrawer(GuiGraphics drawContext, float partialTicks, ProfilerFiller profiler, Minecraft mc) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getBooleanValue() && MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY.getKeybind().isKeybindHeld()) {
            TestInventoryOverlayHandler.getInstance().getRenderContext(drawContext, profiler, mc);
        }
    }

    @Override
    public void onRenderGameOverlayPost(GuiGraphics drawContext) {
    }

    @Override
    public void onRenderWorldLast(Matrix4f posMatrix, Matrix4f projMatrix) {
        Minecraft mc = Minecraft.getInstance();
        ProfilerFiller profiler = mc.getProfiler();
        if (mc.player != null) {
            profiler.push("mafglib_targeting_overlay");
            this.renderTargetingOverlay(posMatrix, mc);
            profiler.pop();
            this.onRenderWorldTestWalls(posMatrix, projMatrix, mc.gameRenderer.getMainCamera(), profiler);
        }
    }

    @Override
    public void onRenderTooltipComponentInsertFirst(Item.TooltipContext context, ItemStack stack, List<Component> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.add(StringUtils.translateAsText("malilib.gui.tooltip.test.first", new Object[0]));
        }
    }

    @Override
    public void onRenderTooltipComponentInsertMiddle(Item.TooltipContext context, ItemStack stack, List<Component> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.add(StringUtils.translateAsText("malilib.gui.tooltip.test.middle", new Object[0]));
        }
    }

    @Override
    public void onRenderTooltipComponentInsertLast(Item.TooltipContext context, ItemStack stack, List<Component> list) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            list.add(StringUtils.translateAsText("malilib.gui.tooltip.test.last", new Object[0]));
        }
    }

    public void onRenderWorldTestWalls(Matrix4f posMatrix, Matrix4f projMatrix, Camera camera, ProfilerFiller profiler) {
        if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue()) {
            Minecraft mc = Minecraft.getInstance();
            profiler.push("mafglib_test_walls");
            if (ConfigTestEnum.TEST_WALLS_HOTKEY.getBooleanValue()) {
                if (TestWalls.needsUpdate(camera.getBlockPosition())) {
                    TestWalls.update(camera, mc);
                }
                TestWalls.draw(camera.getPosition(), posMatrix, projMatrix, mc, profiler);
            }
            profiler.pop();
        }
    }

    @Override
    public void onRenderTooltipLast(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        Item item = stack.getItem();
        if (item instanceof MapItem) {
            if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
                RenderUtils.renderMapPreview(stack, x, y, 160, false);
            }
        } else if (stack.getComponents().has(DataComponents.CONTAINER) && InventoryUtils.shulkerBoxHasItems(stack)) {
            if (MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
                RenderUtils.renderShulkerBoxPreview(stack, x, y, true, drawContext);
            }
        } else if (stack.getComponents().has(DataComponents.BUNDLE_CONTENTS) && InventoryUtils.bundleHasItems(stack) && MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isShiftDown()) {
            RenderUtils.renderBundlePreview(stack, x, y, MaLiLibConfigs.Test.TEST_BUNDLE_PREVIEW_WIDTH.getIntegerValue(), true, drawContext);
        }
    }

    @Override
    public Supplier<String> getProfilerSectionSupplier() {
        return () -> "mafglib_test";
    }

    private void renderTargetingOverlay(Matrix4f posMatrix, Minecraft mc) {
        Entity entity = mc.getCameraEntity();
        if (entity != null && mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK && MaLiLibConfigs.Test.TEST_CONFIG_BOOLEAN.getBooleanValue() && GuiBase.isCtrlDown()) {
            BlockHitResult hitResult = (BlockHitResult)mc.hitResult;
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderUtils.setupBlend();
            Color4f color = Color4f.fromColor(StringUtils.getColor("#C03030F0", 0));
            RenderUtils.renderBlockTargetingOverlay(entity, hitResult.getBlockPos(), hitResult.getDirection(), hitResult.getLocation(), color, posMatrix, mc);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void renderInventoryOverlayOG(InventoryOverlay.Context context, GuiGraphics drawContext, Minecraft mc) {
        LivingEntity entityLivingBase = null;
        BlockEntity be = null;
        Container inv = null;
        CompoundTag nbt = new CompoundTag();
        if (context == null) {
            return;
        }
        if (context.be() != null) {
            be = context.be();
        } else if (context.entity() != null && context.entity() instanceof LivingEntity) {
            entityLivingBase = context.entity();
        }
        if (context.inv() != null) {
            inv = context.inv();
        }
        if (context.nbt() != null) {
            nbt.merge(context.nbt());
        }
        boolean isWolf = entityLivingBase instanceof Wolf;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        MaLiLib.LOGGER.error("0: -> inv.type [{}] // nbt.type [{}]", (Object)(context.inv() != null ? InventoryOverlay.getInventoryType(context.inv()) : null), context.nbt() != null ? InventoryOverlay.getInventoryType(context.nbt()) : null);
        MaLiLib.LOGGER.error("1: -> inv.size [{}] // inv.isEmpty [{}]", (Object)(context.inv() != null ? context.inv().getContainerSize() : -1), (Object)(context.inv() != null ? (Comparable<Boolean>)Boolean.valueOf(context.inv().isEmpty()) : (Comparable<Boolean>)Integer.valueOf(-1)));
        if (inv != null && inv.getContainerSize() > 0) {
            Block block;
            boolean isHorse = entityLivingBase instanceof AbstractHorse;
            int totalSlots = isHorse ? inv.getContainerSize() - 1 : inv.getContainerSize();
            int firstSlot = isHorse ? 1 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof Villager ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType(inv, nbt, context);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            HashSet<Integer> lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if (be != null && type == InventoryOverlay.InventoryRenderType.CRAFTER) {
                if (be instanceof CrafterBlockEntity) {
                    CrafterBlockEntity cbe = (CrafterBlockEntity)be;
                    lockedSlots = BlockUtils.getDisabledSlots(cbe);
                } else if (context.nbt() != null) {
                    lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(context.nbt());
                }
            }
            if (context.be() != null && (block = context.be().getBlockState().getBlock()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock sbb = (ShulkerBoxBlock)block;
                RenderUtils.setShulkerboxBackgroundTintColor(sbb, true);
            }
            MaLiLib.LOGGER.warn("render():0: type [{}] // Nbt Type [{}]", (Object)type.toString(), context.nbt() != null ? InventoryOverlay.getInventoryType(context.nbt()) : "INVALID");
            if (isHorse) {
                SimpleContainer horseInv = new SimpleContainer(2);
                ItemStack horseArmor = ((AbstractHorse)entityLivingBase).getBodyArmorItem();
                horseInv.setItem(0, horseArmor != null && !horseArmor.isEmpty() ? horseArmor : ItemStack.EMPTY);
                horseInv.setItem(1, inv.getItem(0));
                InventoryOverlay.renderInventoryBackground(type, xInv, yInv, 1, 2, mc);
                if (type == InventoryOverlay.InventoryRenderType.LLAMA) {
                    InventoryOverlay.renderLlamaArmorBackgroundSlots((Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, drawContext);
                } else {
                    InventoryOverlay.renderHorseArmorBackgroundSlots((Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, drawContext);
                }
                InventoryOverlay.renderInventoryStacks(type, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, 2, mc, drawContext);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground(type, xInv, yInv, props.slotsPerRow, totalSlots, mc);
                InventoryOverlay.renderInventoryStacks(type, inv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, props.slotsPerRow, firstSlot, totalSlots, lockedSlots, mc, drawContext);
            }
        }
        if (isWolf) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.HORSE;
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, 2);
            int rows = (int)Math.ceil(2.0 / (double)props.slotsPerRow);
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            x = xCenter - 55;
            int xInv = xCenter + 2;
            yInv = Math.min(yInv, yCenter - 92);
            SimpleContainer wolfInv = new SimpleContainer(2);
            ItemStack wolfArmor = ((Wolf)entityLivingBase).getBodyArmorItem();
            wolfInv.setItem(0, wolfArmor != null && !wolfArmor.isEmpty() ? wolfArmor : ItemStack.EMPTY);
            InventoryOverlay.renderInventoryBackground(type, xInv, yInv, 1, 2, mc);
            InventoryOverlay.renderInventoryStacks(type, (Container)wolfInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, 2, mc, drawContext);
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground(x, y, entityLivingBase, drawContext);
            InventoryOverlay.renderEquipmentStacks(entityLivingBase, x, y, mc, drawContext);
        }
    }
}

