/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.malilib.network.IClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class ClientPlayHandler<T extends CustomPacketPayload>
implements IClientPlayHandler {
    private static final ClientPlayHandler<CustomPacketPayload> INSTANCE = new ClientPlayHandler();
    private final ArrayListMultimap<ResourceLocation, IPluginClientPlayHandler<T>> handlers = ArrayListMultimap.create();

    public static IClientPlayHandler getInstance() {
        return INSTANCE;
    }

    private ClientPlayHandler() {
    }

    @Override
    public <P extends CustomPacketPayload> void registerClientPlayHandler(IPluginClientPlayHandler<P> handler) {
        ResourceLocation channel = handler.getPayloadChannel();
        if (!this.handlers.containsEntry((Object)channel, handler)) {
            this.handlers.put((Object)channel, handler);
        }
    }

    @Override
    public <P extends CustomPacketPayload> void unregisterClientPlayHandler(IPluginClientPlayHandler<P> handler) {
        ResourceLocation channel = handler.getPayloadChannel();
        if (this.handlers.remove((Object)channel, handler)) {
            handler.reset(channel);
            handler.unregisterPlayReceiver();
        }
    }

    @ApiStatus.Internal
    public void reset(ResourceLocation channel) {
        if (!this.handlers.isEmpty()) {
            for (IPluginClientPlayHandler handler : this.handlers.get((Object)channel)) {
                handler.reset(channel);
            }
        }
    }
}

