/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigColorList;
import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.IConfigFloat;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.IConfigLockedList;
import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigResettable;
import fi.dy.masa.malilib.config.IConfigSlider;
import fi.dy.masa.malilib.config.IConfigStringList;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.IStringRepresentable;
import fi.dy.masa.malilib.config.gui.ConfigOptionChangeListenerButton;
import fi.dy.masa.malilib.config.gui.ConfigOptionChangeListenerKeybind;
import fi.dy.masa.malilib.config.gui.ConfigOptionChangeListenerTextField;
import fi.dy.masa.malilib.config.gui.ConfigOptionListenerResetConfig;
import fi.dy.masa.malilib.config.gui.SliderCallbackDouble;
import fi.dy.masa.malilib.config.gui.SliderCallbackFloat;
import fi.dy.masa.malilib.config.gui.SliderCallbackInteger;
import fi.dy.masa.malilib.config.options.BooleanHotkeyGuiWrapper;
import fi.dy.masa.malilib.config.options.ConfigBooleanHotkeyed;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ConfigButtonBoolean;
import fi.dy.masa.malilib.gui.button.ConfigButtonColorList;
import fi.dy.masa.malilib.gui.button.ConfigButtonKeybind;
import fi.dy.masa.malilib.gui.button.ConfigButtonLockedList;
import fi.dy.masa.malilib.gui.button.ConfigButtonOptionList;
import fi.dy.masa.malilib.gui.button.ConfigButtonStringList;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IConfigInfoProvider;
import fi.dy.masa.malilib.gui.interfaces.IKeybindConfigGui;
import fi.dy.masa.malilib.gui.interfaces.ISliderCallback;
import fi.dy.masa.malilib.gui.widgets.WidgetColorIndicator;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOptionBase;
import fi.dy.masa.malilib.gui.widgets.WidgetHoverInfo;
import fi.dy.masa.malilib.gui.widgets.WidgetKeybindSettings;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptionsBase;
import fi.dy.masa.malilib.gui.widgets.WidgetSlider;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public class WidgetConfigOption
extends WidgetConfigOptionBase<GuiConfigsBase.ConfigOptionWrapper> {
    protected final GuiConfigsBase.ConfigOptionWrapper wrapper;
    protected final IKeybindConfigGui host;
    @Nullable
    protected final KeybindSettings initialKeybindSettings;
    @Nullable
    protected ImmutableList<String> initialStringList;
    protected int colorDisplayPosX;
    private boolean initialBoolean;

    public WidgetConfigOption(int x, int y, int width, int height, int labelWidth, int configWidth, GuiConfigsBase.ConfigOptionWrapper wrapper, int listIndex, IKeybindConfigGui host, WidgetListConfigOptionsBase<?, ?> parent) {
        super(x, y, width, height, parent, wrapper, listIndex);
        this.host = host;
        this.wrapper = wrapper;
        if (wrapper.getType() == GuiConfigsBase.ConfigOptionWrapper.Type.CONFIG) {
            IConfigBase config;
            IConfigBase iConfigBase = config = wrapper.getConfig();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanHotkeyGuiWrapper.class, ConfigBooleanHotkeyed.class, IStringRepresentable.class}, (Object)iConfigBase, n)) {
                case 0: {
                    BooleanHotkeyGuiWrapper booleanHotkey = (BooleanHotkeyGuiWrapper)iConfigBase;
                    this.initialBoolean = booleanHotkey.getBooleanValue();
                    this.initialStringValue = booleanHotkey.getKeybind().getStringValue();
                    this.initialKeybindSettings = booleanHotkey.getKeybind().getSettings();
                    break;
                }
                case 1: {
                    ConfigBooleanHotkeyed booleanHotkey = (ConfigBooleanHotkeyed)iConfigBase;
                    this.initialBoolean = booleanHotkey.getBooleanValue();
                    this.initialStringValue = booleanHotkey.getKeybind().getStringValue();
                    this.initialKeybindSettings = booleanHotkey.getKeybind().getSettings();
                    break;
                }
                case 2: {
                    IStringRepresentable configStr = (IStringRepresentable)((Object)iConfigBase);
                    this.initialStringValue = configStr.getStringValue();
                    this.lastAppliedValue = configStr.getStringValue();
                    this.initialKeybindSettings = config.getType() == ConfigType.HOTKEY ? ((IHotkey)config).getKeybind().getSettings() : null;
                    break;
                }
                default: {
                    this.initialStringValue = null;
                    this.lastAppliedValue = null;
                    this.initialKeybindSettings = null;
                    if (!(config instanceof IConfigStringList)) break;
                    this.initialStringList = ImmutableList.copyOf(((IConfigStringList)config).getStrings());
                }
            }
            this.addConfigOption(x, y, this.zLevel, labelWidth, configWidth, config);
        } else {
            this.initialStringValue = null;
            this.lastAppliedValue = null;
            this.initialKeybindSettings = null;
            this.addLabel(x, y + 7, labelWidth, 8, -1, wrapper.getLabel());
        }
    }

    protected void addConfigOption(int x, int y, float zLevel, int labelWidth, int configWidth, IConfigBase config) {
        ConfigType type = config.getType();
        int configHeight = 20;
        String configName = config.getConfigGuiDisplayName();
        this.addLabel(x, ++y + 7, labelWidth, 8, -1, configName);
        IConfigInfoProvider infoProvider = this.host.getHoverInfoProvider();
        String comment = infoProvider != null ? infoProvider.getHoverInfo(config) : config.getComment();
        if (comment != null) {
            this.addConfigComment(x, y + 5, labelWidth, 12, comment);
        }
        x += labelWidth + 10;
        if (config instanceof BooleanHotkeyGuiWrapper) {
            BooleanHotkeyGuiWrapper wrapper = (BooleanHotkeyGuiWrapper)config;
            IConfigBoolean booleanConfig = wrapper.getBooleanConfig();
            IKeybind keybind = wrapper.getKeybind();
            this.addBooleanAndHotkeyWidgets(x, y, configWidth, wrapper, booleanConfig, keybind);
        } else if (config instanceof ConfigBooleanHotkeyed) {
            ConfigBooleanHotkeyed hotkeyedBoolean = (ConfigBooleanHotkeyed)config;
            IKeybind keybind = hotkeyedBoolean.getKeybind();
            this.addBooleanAndHotkeyWidgets(x, y, configWidth, hotkeyedBoolean, hotkeyedBoolean, keybind);
        } else if (type == ConfigType.BOOLEAN) {
            ConfigButtonBoolean optionButton = new ConfigButtonBoolean(x, y, configWidth, configHeight, (IConfigBoolean)config);
            this.addConfigButtonEntry(x + configWidth + 2, y, (IConfigResettable)((Object)config), optionButton);
        } else if (type == ConfigType.OPTION_LIST) {
            ConfigButtonOptionList optionButton = new ConfigButtonOptionList(x, y, configWidth, configHeight, (IConfigOptionList)((Object)config));
            this.addConfigButtonEntry(x + configWidth + 2, y, (IConfigResettable)((Object)config), optionButton);
        } else if (type == ConfigType.STRING_LIST) {
            ConfigButtonStringList optionButton = new ConfigButtonStringList(x, y, configWidth, configHeight, (IConfigStringList)config, this.host, this.host.getDialogHandler());
            this.addConfigButtonEntry(x + configWidth + 2, y, (IConfigResettable)((Object)config), optionButton);
        } else if (type == ConfigType.LOCKED_LIST) {
            ConfigButtonLockedList optionButton = new ConfigButtonLockedList(x, y, configWidth, configHeight, (IConfigLockedList)config, this.host, this.host.getDialogHandler());
            this.addConfigButtonEntry(x + configWidth + 2, y, (IConfigResettable)((Object)config), optionButton);
        } else if (type == ConfigType.COLOR_LIST) {
            ConfigButtonColorList optionButton = new ConfigButtonColorList(x, y, configWidth, configHeight, (IConfigColorList)config, this.host, this.host.getDialogHandler());
            this.addConfigButtonEntry(x + configWidth + 2, y, (IConfigResettable)((Object)config), optionButton);
        } else if (type == ConfigType.HOTKEY) {
            this.addHotkeyConfigElements(x, y, configWidth, config.getName(), (IHotkey)config);
        } else if (type == ConfigType.STRING || type == ConfigType.COLOR || type == ConfigType.INTEGER || type == ConfigType.DOUBLE || type == ConfigType.FLOAT) {
            int resetX = x + configWidth + 2;
            if (type == ConfigType.COLOR) {
                this.colorDisplayPosX = x + (configWidth -= 22) + 2;
                this.addWidget(new WidgetColorIndicator(this.colorDisplayPosX, y + 1, 19, 19, (IConfigInteger)config));
            } else if (type == ConfigType.INTEGER || type == ConfigType.DOUBLE || type == ConfigType.FLOAT) {
                this.colorDisplayPosX = x + (configWidth -= 18) + 2;
            }
            if ((type == ConfigType.INTEGER || type == ConfigType.DOUBLE || type == ConfigType.FLOAT) && config instanceof IConfigSlider && ((IConfigSlider)config).shouldUseSlider()) {
                this.addConfigSliderEntry(x, y, resetX, configWidth, configHeight, (IConfigSlider)config);
            } else {
                this.addConfigTextFieldEntry(x, y, resetX, configWidth, configHeight, (IConfigValue)config);
            }
            if (type != ConfigType.COLOR && config instanceof IConfigSlider) {
                MaLiLibIcons icon = ((IConfigSlider)config).shouldUseSlider() ? MaLiLibIcons.BTN_TXTFIELD : MaLiLibIcons.BTN_SLIDER;
                ButtonGeneric toggleBtn = new ButtonGeneric(this.colorDisplayPosX, y + 2, icon, new String[0]);
                this.addButton(toggleBtn, new ListenerSliderToggle((IConfigSlider)config));
            }
        }
    }

    @Override
    public boolean wasConfigModified() {
        if (this.wrapper.getType() == GuiConfigsBase.ConfigOptionWrapper.Type.CONFIG) {
            IConfigBase config = this.wrapper.getConfig();
            boolean modified = false;
            if (config instanceof BooleanHotkeyGuiWrapper) {
                BooleanHotkeyGuiWrapper booleanHotkey = (BooleanHotkeyGuiWrapper)config;
                IKeybind keybind = booleanHotkey.getKeybind();
                return this.initialBoolean != booleanHotkey.getBooleanValue() || !this.initialStringValue.equals(keybind.getStringValue()) || !this.initialKeybindSettings.equals(keybind.getSettings());
            }
            if (config instanceof ConfigBooleanHotkeyed) {
                ConfigBooleanHotkeyed booleanHotkey = (ConfigBooleanHotkeyed)config;
                IKeybind keybind = booleanHotkey.getKeybind();
                return this.initialBoolean != booleanHotkey.getBooleanValue() || !this.initialStringValue.equals(keybind.getStringValue()) || !this.initialKeybindSettings.equals(keybind.getSettings());
            }
            if (config instanceof IStringRepresentable) {
                if (this.textField != null) {
                    modified |= !this.initialStringValue.equals(this.textField.getTextField().getValue());
                }
                if (this.initialKeybindSettings != null && !this.initialKeybindSettings.equals(((IHotkey)config).getKeybind().getSettings())) {
                    modified = true;
                }
                return modified || !this.initialStringValue.equals(((IStringRepresentable)((Object)config)).getStringValue());
            }
            if (this.initialStringList != null && config instanceof IConfigStringList) {
                return !this.initialStringList.equals(((IConfigStringList)config).getStrings());
            }
        }
        return false;
    }

    @Override
    public void applyNewValueToConfig() {
        IConfigBase iConfigBase;
        if (this.wrapper.getType() == GuiConfigsBase.ConfigOptionWrapper.Type.CONFIG && (iConfigBase = this.wrapper.getConfig()) instanceof IStringRepresentable) {
            IStringRepresentable config = (IStringRepresentable)((Object)iConfigBase);
            if (this.textField != null && this.hasPendingModifications()) {
                config.setValueFromString(this.textField.getTextField().getValue());
            }
            this.lastAppliedValue = config.getStringValue();
        }
    }

    protected void addConfigComment(int x, int y, int width, int height, String comment) {
        this.addWidget(new WidgetHoverInfo(x, y, width, height, comment, new Object[0]));
    }

    protected void addHotkeyConfigElements(int x, int y, int configWidth, String configName, IHotkey hotkey) {
        IKeybind keybind = hotkey.getKeybind();
        ConfigButtonKeybind keybindButton = new ConfigButtonKeybind(x, y, configWidth -= 22, 20, keybind, this.host);
        this.addWidget(new WidgetKeybindSettings(x += configWidth + 2, y, 20, 20, keybind, configName, this.parent, this.host.getDialogHandler()));
        this.addButton(keybindButton, this.host.getButtonPressListener());
        this.addKeybindResetButton(x += 22, y, keybind, keybindButton);
    }

    protected void addBooleanAndHotkeyWidgets(int x, int y, int configWidth, IConfigResettable resettableConfig, IConfigBoolean booleanConfig, IKeybind keybind) {
        int booleanBtnWidth = 60;
        ConfigButtonBoolean booleanButton = new ConfigButtonBoolean(x, y, booleanBtnWidth, 20, booleanConfig);
        ConfigButtonKeybind keybindButton = new ConfigButtonKeybind(x += booleanBtnWidth + 2, y, configWidth -= booleanBtnWidth + 2 + 22, 20, keybind, this.host);
        this.addWidget(new WidgetKeybindSettings(x += configWidth + 2, y, 20, 20, keybind, booleanConfig.getName(), this.parent, this.host.getDialogHandler()));
        ButtonGeneric resetButton = this.createResetButton(x += 22, y, resettableConfig);
        ConfigOptionChangeListenerButton booleanChangeListener = new ConfigOptionChangeListenerButton(resettableConfig, resetButton, null);
        HotkeyedBooleanResetListener resetListener = new HotkeyedBooleanResetListener(resettableConfig, booleanButton, keybindButton, resetButton, this.host);
        this.host.addKeybindChangeListener(resetListener::updateButtons);
        this.addButton(booleanButton, booleanChangeListener);
        this.addButton(keybindButton, this.host.getButtonPressListener());
        this.addButton(resetButton, resetListener);
    }

    protected void addConfigButtonEntry(int xReset, int yReset, IConfigResettable config, ButtonBase optionButton) {
        ButtonGeneric resetButton = this.createResetButton(xReset, yReset, config);
        ConfigOptionChangeListenerButton listenerChange = new ConfigOptionChangeListenerButton(config, resetButton, null);
        ConfigOptionListenerResetConfig listenerReset = new ConfigOptionListenerResetConfig(config, new ConfigOptionListenerResetConfig.ConfigResetterButton(optionButton), resetButton, null);
        this.addButton(optionButton, listenerChange);
        this.addButton(resetButton, listenerReset);
    }

    protected void addConfigTextFieldEntry(int x, int y, int resetX, int configWidth, int configHeight, IConfigValue config) {
        GuiTextFieldGeneric field = this.createTextField(x, y + 1, configWidth - 4, configHeight - 3);
        field.setMaxLength(this.maxTextfieldTextLength);
        field.setValue(config.getStringValue());
        ButtonGeneric resetButton = this.createResetButton(resetX, y, config);
        ConfigOptionChangeListenerTextField listenerChange = new ConfigOptionChangeListenerTextField(config, field, resetButton);
        ConfigOptionListenerResetConfig listenerReset = new ConfigOptionListenerResetConfig(config, new ConfigOptionListenerResetConfig.ConfigResetterTextField(config, field), resetButton, null);
        this.addTextField(field, listenerChange);
        this.addButton(resetButton, listenerReset);
    }

    protected void addConfigSliderEntry(int x, int y, int resetX, int configWidth, int configHeight, IConfigSlider config) {
        ISliderCallback callback;
        ButtonGeneric resetButton = this.createResetButton(resetX, y, config);
        IConfigSlider iConfigSlider = config;
        Objects.requireNonNull(iConfigSlider);
        IConfigSlider iConfigSlider2 = iConfigSlider;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IConfigDouble.class, IConfigFloat.class, IConfigInteger.class}, (Object)iConfigSlider2, n)) {
            case 0: {
                IConfigDouble iConfigDouble = (IConfigDouble)iConfigSlider2;
                callback = new SliderCallbackDouble(iConfigDouble, resetButton);
                break;
            }
            case 1: {
                IConfigFloat iConfigFloat = (IConfigFloat)iConfigSlider2;
                callback = new SliderCallbackFloat(iConfigFloat, resetButton);
                break;
            }
            case 2: {
                IConfigInteger iConfigInteger = (IConfigInteger)iConfigSlider2;
                callback = new SliderCallbackInteger(iConfigInteger, resetButton);
                break;
            }
            default: {
                return;
            }
        }
        WidgetSlider slider = new WidgetSlider(x, y, configWidth, configHeight, callback);
        ConfigOptionListenerResetConfig listenerReset = new ConfigOptionListenerResetConfig(config, null, resetButton, null);
        this.addWidget(slider);
        this.addButton(resetButton, listenerReset);
    }

    protected void addKeybindResetButton(int x, int y, IKeybind keybind, ConfigButtonKeybind buttonHotkey) {
        ButtonGeneric button = this.createResetButton(x, y, keybind);
        ConfigOptionChangeListenerKeybind listener = new ConfigOptionChangeListenerKeybind(keybind, buttonHotkey, button, this.host);
        this.host.addKeybindChangeListener(listener::updateButtons);
        this.addButton(button, listener);
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, GuiGraphics drawContext) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawSubWidgets(mouseX, mouseY, drawContext);
        if (this.wrapper.getType() == GuiConfigsBase.ConfigOptionWrapper.Type.CONFIG) {
            this.drawTextFields(mouseX, mouseY, drawContext);
            super.render(mouseX, mouseY, selected, drawContext);
        }
    }

    public static class ListenerSliderToggle
    implements IButtonActionListener {
        protected final IConfigSlider config;

        public ListenerSliderToggle(IConfigSlider config) {
            this.config = config;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            this.config.toggleUseSlider();
            Screen gui = GuiUtils.getCurrentScreen();
            if (gui instanceof GuiBase) {
                ((GuiBase)gui).initGui();
            }
        }
    }

    public static class HotkeyedBooleanResetListener
    implements IButtonActionListener {
        private final IConfigResettable config;
        private final ButtonGeneric booleanButton;
        private final ConfigButtonKeybind hotkeyButton;
        private final ButtonGeneric resetButton;
        private final IKeybindConfigGui host;

        public HotkeyedBooleanResetListener(IConfigResettable config, ButtonGeneric booleanButton, ConfigButtonKeybind hotkeyButton, ButtonGeneric resetButton, IKeybindConfigGui host) {
            this.config = config;
            this.booleanButton = booleanButton;
            this.hotkeyButton = hotkeyButton;
            this.resetButton = resetButton;
            this.host = host;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            this.config.resetToDefault();
            this.host.getButtonPressListener().actionPerformedWithButton(button, mouseButton);
            this.updateButtons();
        }

        public void updateButtons() {
            this.booleanButton.updateDisplayString();
            this.hotkeyButton.updateDisplayString();
            this.resetButton.setEnabled(this.config.isModified());
        }
    }
}

