/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.impl;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Collection;
import java.util.Map;
import malte0811.ferritecore.ducks.FastMapStateHolder;
import malte0811.ferritecore.fastmap.FastMap;
import malte0811.ferritecore.fastmap.table.CrashNeighborTable;
import malte0811.ferritecore.fastmap.table.FastmapNeighborTable;
import malte0811.ferritecore.impl.FastMapEntryMap;
import malte0811.ferritecore.mixin.config.FerriteConfig;
import net.minecraft.world.level.block.state.properties.Property;

public class StateHolderImpl {
    public static final ThreadLocal<Map<Map<Property<?>, Comparable<?>>, ?>> LAST_STATE_MAP = new ThreadLocal();
    public static final ThreadLocal<FastMap<?>> LAST_FAST_STATE_MAP = new ThreadLocal();

    public static <S> void populateNeighbors(Map<Map<Property<?>, Comparable<?>>, S> states, FastMapStateHolder<S> holder) {
        if (states.size() == 1) {
            holder.setNeighborTable((Table<Property<?>, Comparable<?>, ?>)ImmutableTable.of());
            holder.replacePropertyMap(Reference2ObjectMaps.emptyMap());
            return;
        }
        if (holder.getNeighborTable() != null) {
            throw new IllegalStateException();
        }
        if (states == LAST_STATE_MAP.get()) {
            holder.setStateMap(LAST_FAST_STATE_MAP.get());
        } else {
            LAST_STATE_MAP.set(states);
            FastMap<S> globalTable = new FastMap<S>((Collection<Property<?>>)holder.getVanillaPropertyMap().keySet(), states, FerriteConfig.COMPACT_FAST_MAP.isEnabled());
            holder.setStateMap(globalTable);
            LAST_FAST_STATE_MAP.set(globalTable);
        }
        int index = holder.getStateMap().getIndexOf((Map<Property<?>, Comparable<?>>)holder.getVanillaPropertyMap());
        holder.setStateIndex(index);
        if (FerriteConfig.PROPERTY_MAP.isEnabled()) {
            holder.replacePropertyMap(new FastMapEntryMap(holder));
        }
        if (FerriteConfig.POPULATE_NEIGHBOR_TABLE.isEnabled()) {
            holder.setNeighborTable(new FastmapNeighborTable<S>(holder));
        } else {
            holder.setNeighborTable(CrashNeighborTable.getInstance());
        }
    }
}

