/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.rechiseled_chipped.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ScrollWidget
extends BaseWidget {
    private static final ResourceLocation HANDLES = ResourceLocation.fromNamespaceAndPath((String)"rechiseled", (String)"textures/screen/handles.png");
    private final Runnable onScrollChanged;
    private final int handleWidth = 14;
    private final int handleHeight = 17;
    private boolean isDragging = false;
    private float scrollRatio = 0.0f;
    private int intSnapMax = 0;
    private boolean isActive = true;

    public ScrollWidget(int x, int y, int width, int height, Runnable onScrollChanged) {
        super(x, y, width, height);
        this.onScrollChanged = onScrollChanged;
    }

    public void setScrollRatio(float scrollRatio) {
        if (!this.isActive) {
            return;
        }
        if (scrollRatio > 1.0f) {
            scrollRatio = 1.0f;
        }
        if (scrollRatio < 0.0f) {
            scrollRatio = 0.0f;
        }
        this.scrollRatio = scrollRatio;
    }

    public float getScrollRatio() {
        return this.scrollRatio;
    }

    public void setIntSnapMax(int intSnapMax) {
        this.intSnapMax = intSnapMax;
    }

    public int getIntSnapMax() {
        return this.intSnapMax;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (!isActive) {
            this.scrollRatio = 0.0f;
        }
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public float getHandleY() {
        return (float)this.y + (float)(this.height - this.handleHeight) * this.scrollRatio;
    }

    public float getHandleHalfHeight() {
        Objects.requireNonNull(this);
        return 17.0f * 0.5f;
    }

    public Component getNarrationMessage() {
        return null;
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.isActive && this.isDragging) {
            float handleHalfHeight = this.getHandleHalfHeight();
            float mouseYRelative = ((float)mouseY - (float)this.y - handleHalfHeight) / (float)Math.max(1, this.height - this.handleHeight);
            if (this.intSnapMax > 0) {
                mouseYRelative = (float)Math.floor(mouseYRelative * (float)this.intSnapMax) / (float)this.intSnapMax;
            }
            this.setScrollRatio(mouseYRelative);
            if (this.onScrollChanged != null) {
                this.onScrollChanged.run();
            }
        }
        ScreenUtils.bindTexture((ResourceLocation)HANDLES);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.getHandleY(), (float)14.0f, (float)17.0f, (float)0.0f, (float)(this.isActive ? 0.0f : 0.5f), (float)1.0f, (float)0.5f);
        super.render(context, mouseX, mouseY);
    }

    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        this.isDragging = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        this.isDragging = false;
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }
}

