/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.function.Consumer;
import net.creeperhost.polylib.containers.DataManagerContainer;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.creeperhost.polylib.data.DataManagerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolyLibNetwork {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CONTAINER_PACKET_TO_CLIENT = ResourceLocation.fromNamespaceAndPath((String)"polylib", (String)"container_client");
    private static final ResourceLocation TILE_DATA_VALUE_TO_CLIENT = ResourceLocation.fromNamespaceAndPath((String)"polylib", (String)"tile_client");
    private static final ResourceLocation CONTAINER_PACKET_TO_SERVER = ResourceLocation.fromNamespaceAndPath((String)"polylib", (String)"container_packet_server");
    private static final ResourceLocation TILE_DATA_VALUE_TO_SERVER = ResourceLocation.fromNamespaceAndPath((String)"polylib", (String)"tile_data_server");
    private static final ResourceLocation TILE_PACKET_TO_SERVER = ResourceLocation.fromNamespaceAndPath((String)"polylib", (String)"tile_packet_server");

    public static void init() {
        if (Platform.getEnv() == Dist.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)CONTAINER_PACKET_TO_CLIENT, (buf, context) -> {
                ByteBuf copy = buf.copy();
                context.queue(() -> ModularGuiContainerMenu.handlePacketFromServer(context.getPlayer(), new RegistryFriendlyByteBuf(copy, buf.registryAccess())));
            });
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)TILE_DATA_VALUE_TO_CLIENT, (buf, context) -> {
                ByteBuf copy = buf.copy();
                context.queue(() -> PolyLibNetwork.handleTileDataValueFromServer(context.getPlayer(), new RegistryFriendlyByteBuf(copy, buf.registryAccess())));
            });
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)CONTAINER_PACKET_TO_SERVER, (buf, context) -> {
            ByteBuf copy = buf.copy();
            context.queue(() -> ModularGuiContainerMenu.handlePacketFromClient(context.getPlayer(), new RegistryFriendlyByteBuf(copy, buf.registryAccess())));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)TILE_DATA_VALUE_TO_SERVER, (buf, context) -> {
            ByteBuf copy = buf.copy();
            context.queue(() -> PolyLibNetwork.handleTileDataValueFromClient(context.getPlayer(), new RegistryFriendlyByteBuf(copy, buf.registryAccess())));
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)TILE_PACKET_TO_SERVER, (buf, context) -> {
            ByteBuf copy = buf.copy();
            context.queue(() -> PolyLibNetwork.handleTilePacketFromClient(context.getPlayer(), new RegistryFriendlyByteBuf(copy, buf.registryAccess())));
        });
    }

    public static void sendContainerPacketToServer(RegistryAccess registryAccess, Consumer<RegistryFriendlyByteBuf> packetWriter) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess);
        packetWriter.accept(buf);
        NetworkManager.sendToServer((ResourceLocation)CONTAINER_PACKET_TO_SERVER, (RegistryFriendlyByteBuf)buf);
    }

    public static void sendDataValueToServerTile(RegistryAccess registryAccess, Consumer<RegistryFriendlyByteBuf> packetWriter) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess);
        packetWriter.accept(buf);
        NetworkManager.sendToServer((ResourceLocation)TILE_DATA_VALUE_TO_SERVER, (RegistryFriendlyByteBuf)buf);
    }

    public static void sendPacketToServerTile(RegistryAccess registryAccess, Consumer<RegistryFriendlyByteBuf> packetWriter) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), registryAccess);
        packetWriter.accept(buf);
        NetworkManager.sendToServer((ResourceLocation)TILE_PACKET_TO_SERVER, (RegistryFriendlyByteBuf)buf);
    }

    public static void sendContainerPacketToClient(ServerPlayer player, Consumer<RegistryFriendlyByteBuf> packetWriter) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess());
        packetWriter.accept(buf);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CONTAINER_PACKET_TO_CLIENT, (RegistryFriendlyByteBuf)buf);
    }

    public static void sendTileDataValueToClients(Level level, BlockPos pos, Consumer<RegistryFriendlyByteBuf> packetWriter) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), level.registryAccess());
            packetWriter.accept(buf);
            List players = serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(pos), false);
            NetworkManager.sendToPlayers((Iterable)players, (ResourceLocation)TILE_DATA_VALUE_TO_CLIENT, (RegistryFriendlyByteBuf)buf);
        }
    }

    private static void handleTileDataValueFromClient(Player player, RegistryFriendlyByteBuf packet) {
        try {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof DataManagerContainer) {
                DataManagerContainer menu = (DataManagerContainer)abstractContainerMenu;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    menu.handleDataValueFromClient(serverPlayer, packet);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Something went wrong while attempting to read a value packet sent from this client: {}", (Object)player, (Object)e);
        }
    }

    public static void handleTileDataValueFromServer(Player player, RegistryFriendlyByteBuf packet) {
        BlockPos pos = packet.readBlockPos();
        try {
            BlockEntity blockEntity = player.level().getBlockEntity(pos);
            if (blockEntity instanceof DataManagerBlock) {
                DataManagerBlock tile = (DataManagerBlock)blockEntity;
                tile.getDataManager().handleSyncFromServer(player, packet);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to handle tile data from server. Tile pos: {}", (Object)pos, (Object)e);
        }
    }

    private static void handleTilePacketFromClient(Player player, RegistryFriendlyByteBuf packet) {
        try {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof DataManagerContainer) {
                DataManagerContainer menu = (DataManagerContainer)abstractContainerMenu;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    menu.handlePacketFromClient(serverPlayer, packet);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Something went wrong while attempting to read a packet sent from this client: {}", (Object)player, (Object)e);
        }
    }
}

