/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.inventory.power;

import net.creeperhost.polylib.init.DataComps;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PolyItemEnergyStorage
extends PolyEnergyStorage
implements IPolyEnergyStorageItem {
    private final ItemStack stack;

    public PolyItemEnergyStorage(ItemStack stack, long capacity) {
        super(capacity);
        this.stack = stack;
        this.loadEnergy();
    }

    public PolyItemEnergyStorage(ItemStack stack, long capacity, long maxTransfer) {
        super(capacity, maxTransfer);
        this.stack = stack;
        this.loadEnergy();
    }

    public PolyItemEnergyStorage(ItemStack stack, long capacity, long maxReceive, long maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.stack = stack;
        this.loadEnergy();
    }

    public PolyItemEnergyStorage(ItemStack stack, long capacity, long maxReceive, long maxExtract, Runnable changeListener) {
        super(capacity, maxReceive, maxExtract, changeListener);
        this.stack = stack;
        this.loadEnergy();
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.saveEnergy();
    }

    private void loadEnergy() {
        this.energy = (Long)this.stack.getOrDefault((DataComponentType)DataComps.ITEM_ENERGY.get(), (Object)0L);
    }

    private void saveEnergy() {
        this.stack.set((DataComponentType)DataComps.ITEM_ENERGY.get(), (Object)this.energy);
    }

    @Override
    @NotNull
    public ItemStack getContainer() {
        return this.stack;
    }
}

