/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui;

import java.util.Set;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerGuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerScreenAccess;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularGuiContainer<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements ContainerScreenAccess<T> {
    public final ModularGui modularGui;
    private boolean renderingSlots = false;
    private boolean renderingBackground = false;

    public ModularGuiContainer(T containerMenu, Inventory inventory, ContainerGuiProvider<T> provider) {
        super(containerMenu, inventory, (Component)Component.empty());
        provider.setMenuAccess(this);
        this.modularGui = new ModularGui(provider);
        this.modularGui.setScreen((Screen)this);
    }

    public ModularGui getModularGui() {
        return this.modularGui;
    }

    @NotNull
    public Component getTitle() {
        return this.modularGui.getGuiTitle();
    }

    public boolean shouldCloseOnEsc() {
        return this.modularGui.closeOnEscape();
    }

    protected void init() {
        this.modularGui.onScreenInit(this.minecraft, this.font, this.width, this.height);
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.modularGui.onScreenInit(minecraft, this.font, width, height);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiElement<?> root = this.modularGui.getRoot();
        this.topPos = (int)root.getValue(GeoParam.TOP);
        this.leftPos = (int)root.getValue(GeoParam.LEFT);
        this.imageWidth = (int)root.getValue(GeoParam.WIDTH);
        this.imageHeight = (int)root.getValue(GeoParam.HEIGHT);
        this.modularGui.setVanillaSlotRendering(false);
        if (this.modularGui.renderBackground()) {
            this.renderingBackground = true;
            this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        }
        this.renderingBackground = false;
        GuiRender render = GuiRender.convert(graphics);
        this.modularGui.render(render, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (!this.handleFloatingItemRender(render, mouseX, mouseY) && !this.renderHoveredStackToolTip(render, mouseX, mouseY)) {
            this.modularGui.renderOverlay(render, partialTicks);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.renderingBackground) {
            super.renderBackground(guiGraphics, i, j, f);
        }
    }

    protected boolean handleFloatingItemRender(GuiRender render, int mouseX, int mouseY) {
        ItemStack stack;
        if (this.modularGui.vanillaSlotRendering()) {
            return false;
        }
        boolean ret = false;
        ItemStack itemStack = stack = this.draggingItem.isEmpty() ? this.menu.getCarried() : this.draggingItem;
        if (!stack.isEmpty()) {
            int yOffset = this.draggingItem.isEmpty() ? 8 : 16;
            String countOverride = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                stack = stack.copyWithCount(Mth.ceil((float)((float)stack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && (stack = stack.copyWithCount(this.quickCraftingRemainder)).isEmpty()) {
                countOverride = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            this.renderFloatingItem(render, stack, mouseX - 8, mouseY - yOffset, countOverride);
            ret = true;
        }
        if (!this.snapbackItem.isEmpty()) {
            float anim = (float)(Util.getMillis() - this.snapbackTime) / 100.0f;
            if (anim >= 1.0f) {
                anim = 1.0f;
                this.snapbackItem = ItemStack.EMPTY;
            }
            int xDist = this.snapbackEnd.x - this.snapbackStartX;
            int yDist = this.snapbackEnd.y - this.snapbackStartY;
            int xPos = this.snapbackStartX + (int)((float)xDist * anim);
            int yPos = this.snapbackStartY + (int)((float)yDist * anim);
            this.renderFloatingItem(render, this.snapbackItem, xPos + this.leftPos, yPos + this.topPos, null);
            ret = true;
        }
        return ret;
    }

    protected boolean renderHoveredStackToolTip(GuiRender guiGraphics, int mouseX, int mouseY) {
        if (this.menu.getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            GuiElement<?> handler = this.modularGui.getSlotHandler(this.hoveredSlot);
            if (handler != null && (handler.blockMouseOver(handler, mouseX, mouseY) || !handler.isMouseOver())) {
                return false;
            }
            ItemStack itemStack = this.hoveredSlot.getItem();
            guiGraphics.toolTipWithImage(this.getTooltipFromContainerItem(itemStack), itemStack.getTooltipImage(), mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected void containerTick() {
        this.modularGui.tick();
    }

    public void removed() {
        super.removed();
        this.modularGui.onGuiClose();
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.modularGui.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.modularGui.mouseClicked(mouseX, mouseY, button) || super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.modularGui.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.modularGui.mouseScrolled(mouseX, mouseY, scrollX, scrollY) || super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        return this.modularGui.keyPressed(key, scancode, modifiers) || super.keyPressed(key, scancode, modifiers);
    }

    public boolean keyReleased(int key, int scancode, int modifiers) {
        return this.modularGui.keyReleased(key, scancode, modifiers) || super.keyReleased(key, scancode, modifiers);
    }

    public boolean charTyped(char character, int modifiers) {
        return this.modularGui.charTyped(character, modifiers) || super.charTyped(character, modifiers);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
    }

    public void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (this.modularGui.vanillaSlotRendering()) {
            super.renderSlot(guiGraphics, slot);
        } else {
            this.renderingSlots = true;
        }
    }

    @Override
    public void renderSlot(GuiRender render, Slot slot) {
        if (this.modularGui.vanillaSlotRendering()) {
            return;
        }
        int slotX = slot.x + this.leftPos;
        int slotY = slot.y + this.topPos;
        ItemStack slotStack = slot.getItem();
        boolean dragingToSlot = false;
        boolean dontRenderItem = slot == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
        ItemStack carriedStack = this.menu.getCarried();
        String countString = null;
        if (slot == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !slotStack.isEmpty()) {
            slotStack = slotStack.copyWithCount(slotStack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !carriedStack.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)carriedStack, (boolean)true) && this.menu.canDragTo(slot)) {
                dragingToSlot = true;
                int k = Math.min(carriedStack.getMaxStackSize(), slot.getMaxStackSize(carriedStack));
                int l = slot.getItem().isEmpty() ? 0 : slot.getItem().getCount();
                int m = AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)carriedStack) + l;
                if (m > k) {
                    m = k;
                    countString = ChatFormatting.YELLOW.toString() + k;
                }
                slotStack = carriedStack.copyWithCount(m);
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        if (!dontRenderItem) {
            if (dragingToSlot) {
                render.fill(slotX, slotY, slotX + 16, slotY + 16, -2130706433);
            }
            render.renderItem(slotStack, slotX, (double)slotY, 16.0, slot.x + slot.y * this.imageWidth);
            render.renderItemDecorations(slotStack, (double)slotX, (double)slotY, countString);
        }
    }

    public boolean isHovering(Slot pSlot, double pMouseX, double pMouseY) {
        boolean ret = super.isHovering(pSlot, pMouseX, pMouseY);
        if (ret && this.renderingSlots && pSlot.isActive()) {
            this.hoveredSlot = pSlot;
            return false;
        }
        return ret;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        this.renderingSlots = false;
    }

    public void renderFloatingItem(GuiGraphics guiGraphics, ItemStack itemStack, int i, int j, String string) {
        if (this.modularGui.vanillaSlotRendering()) {
            super.renderFloatingItem(guiGraphics, itemStack, i, j, string);
        }
    }

    public void renderFloatingItem(GuiRender render, ItemStack itemStack, int x, int y, String string) {
        render.pose().pushPose();
        render.pose().translate(0.0f, 0.0f, 50.0f);
        render.renderItem(itemStack, x, y);
        render.renderItemDecorations(itemStack, (double)x, (double)(y - (this.draggingItem.isEmpty() ? 0 : 8)), string);
        render.pose().popPose();
    }

    @Nullable
    public Slot findSlot(double mouseX, double mouseY) {
        Slot slot = super.findSlot(mouseX, mouseY);
        if (slot == null) {
            return null;
        }
        GuiElement<?> handler = this.modularGui.getSlotHandler(slot);
        if (!(handler == null || handler.isEnabled() && handler.isMouseOver())) {
            return null;
        }
        return slot;
    }

    protected void slotClicked(Slot slot, int i, int j, ClickType clickType) {
        GuiElement<?> handler;
        if (slot != null && (handler = this.modularGui.getSlotHandler(slot)) != null && !handler.isEnabled()) {
            return;
        }
        super.slotClicked(slot, i, j, clickType);
    }
}

