/*
 * Decompiled with CFR 0.152.
 */
package create_deep_dark.fluid;

import create_deep_dark.init.CreateDeepDarkModBlocks;
import create_deep_dark.init.CreateDeepDarkModFluidTypes;
import create_deep_dark.init.CreateDeepDarkModFluids;
import create_deep_dark.init.CreateDeepDarkModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class MoltenEchoFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)CreateDeepDarkModFluidTypes.MOLTEN_ECHO_TYPE.get(), () -> (Fluid)CreateDeepDarkModFluids.MOLTEN_ECHO.get(), () -> (Fluid)CreateDeepDarkModFluids.FLOWING_MOLTEN_ECHO.get()).explosionResistance(1000000.0f).tickRate(30).levelDecreasePerBlock(2).bucket(() -> (Item)CreateDeepDarkModItems.MOLTEN_ECHO_BUCKET.get()).block(() -> (LiquidBlock)CreateDeepDarkModBlocks.MOLTEN_ECHO.get());

    private MoltenEchoFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_LAVA;
    }

    public static class Flowing
    extends MoltenEchoFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends MoltenEchoFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

