/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.fluids.dye;

import com.simibubi.create.api.effect.OpenPipeEffectHandler;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringFanProcessingType;
import plus.dragons.createdragonsplus.common.registry.CDPFanProcessingTypes;
import plus.dragons.createdragonsplus.mixin.create.FanProcessingAccessor;

public class DyeFluidOpenPipeEffect
implements OpenPipeEffectHandler {
    private final DyeColor color;

    public DyeFluidOpenPipeEffect(DyeColor color) {
        this.color = color;
    }

    public void apply(Level level, AABB area, FluidStack fluid) {
        ColoringFanProcessingType type = CDPFanProcessingTypes.COLORING.get(this.color).get();
        List entities = level.getEntities((Entity)null, area, entity -> entity instanceof ItemEntity || entity instanceof LivingEntity);
        for (Entity entity2 : entities) {
            if (entity2 instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity2;
                FanProcessingAccessor.invokeApplyProcessing(itemEntity, type);
                continue;
            }
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            type.applyColoring(livingEntity, level);
        }
    }
}

