/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.dd.content;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.liukrast.dd.content.PackageRewriterBlock;
import net.liukrast.dd.registry.RegisterBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class PackageRewriterBlockEntity
extends PackagerBlockEntity {
    public PackageRewriterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntityTypes.PACKAGE_REWRITER.get(), pos, state);
    }

    protected Pair<String, String> getRegexInfo() {
        for (Direction side : Direction.values()) {
            String replacement;
            List firstPage;
            assert (this.level != null);
            BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(side));
            if (blockEntity instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                for (boolean front : Iterate.trueAndFalse) {
                    SignText text = sign.getText(front);
                    String regex = text.getMessages(false)[0].getString();
                    String replacement2 = text.getMessages(false)[1].getString();
                    if (regex.isBlank()) continue;
                    return Pair.of((Object)regex, (Object)replacement2);
                }
                continue;
            }
            if (!(blockEntity instanceof ClipboardBlockEntity)) continue;
            ClipboardBlockEntity clipboard = (ClipboardBlockEntity)blockEntity;
            List data = (List)clipboard.dataContainer.get(AllDataComponents.CLIPBOARD_PAGES);
            if (data == null || (firstPage = (List)data.getFirst()) == null || firstPage.isEmpty()) continue;
            String regex = ((ClipboardEntry)firstPage.getFirst()).text.getString();
            String string = replacement = firstPage.size() > 1 ? ((ClipboardEntry)firstPage.get((int)1)).text.getString() : "";
            if (regex.isBlank()) continue;
            return Pair.of((Object)regex, (Object)replacement);
        }
        return null;
    }

    public boolean unwrapBox(ItemStack box, boolean simulate) {
        if (!((Boolean)this.getBlockState().getValue((Property)PackageRewriterBlock.POWERED)).booleanValue()) {
            return false;
        }
        if (this.animationTicks > 0) {
            return false;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return false;
        }
        boolean targetIsCreativeCrate = targetInv instanceof BottomlessItemHandler;
        boolean anySpace = false;
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack remainder = targetInv.insertItem(slot, box, simulate);
            if (!remainder.isEmpty()) continue;
            anySpace = true;
            break;
        }
        if (!targetIsCreativeCrate && !anySpace) {
            return false;
        }
        if (simulate) {
            return true;
        }
        String current = PackageItem.getAddress((ItemStack)box);
        Pair<String, String> regex = this.getRegexInfo();
        if (regex != null) {
            PackageItem.addAddress((ItemStack)box, (String)current.replaceAll((String)regex.getFirst(), (String)regex.getSecond()));
        }
        this.notifyUpdate();
        this.previouslyUnwrapped = box;
        this.animationInward = true;
        this.animationTicks = 20;
        this.notifyUpdate();
        return true;
    }

    public void attemptToSend(List<PackagingRequest> queuedRequests) {
        if (!this.heldBox.isEmpty() || this.animationTicks != 0 || this.buttonCooldown > 0) {
            return;
        }
        if (!this.queuedExitingPackages.isEmpty()) {
            return;
        }
        IItemHandler targetInv = (IItemHandler)this.targetInventory.getInventory();
        if (targetInv == null || targetInv instanceof PackagerItemHandler) {
            return;
        }
        for (int slot = 0; slot < targetInv.getSlots(); ++slot) {
            ItemStack extracted = targetInv.extractItem(slot, 1, true);
            if (extracted.isEmpty() || !PackageItem.isPackage((ItemStack)extracted)) continue;
            targetInv.extractItem(slot, 1, false);
            this.heldBox = extracted.copy();
            this.animationInward = false;
            this.animationTicks = 20;
            this.notifyUpdate();
            break;
        }
        if (this.heldBox.isEmpty()) {
            return;
        }
        String current = PackageItem.getAddress((ItemStack)this.heldBox);
        Pair<String, String> regex = this.getRegexInfo();
        if (regex != null) {
            PackageItem.addAddress((ItemStack)this.heldBox, (String)current.replaceAll((String)regex.getFirst(), (String)regex.getSecond()));
        }
        this.notifyUpdate();
    }

    public void recheckIfLinksPresent() {
    }

    public boolean redstoneModeActive() {
        return true;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)RegisterBlockEntityTypes.PACKAGE_REWRITER.get(), (be, context) -> be.inventory);
    }
}

