/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.farmersdelight.recipe;

import com.google.common.cache.CacheBuilder;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerRecipeSearchEvent;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import plus.dragons.createcentralkitchen.config.CCKConfig;
import plus.dragons.createdragonsplus.common.recipe.RecipeConverter;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttingBoardRecipeConverters {
    public static final RecipeConverter<CuttingBoardRecipe, CuttingRecipe> SAWING = RecipeConverter.cached((CacheBuilder)CacheBuilder.newBuilder(), holder -> {
        CuttingBoardRecipe recipe = (CuttingBoardRecipe)holder.value();
        ResourceLocation id = holder.id().withSuffix("_using_saw");
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(CuttingRecipe::new, id).require((Ingredient)recipe.getIngredients().getFirst());
        for (ChanceResult result : recipe.getRollableResults()) {
            builder.output(result.chance(), result.stack());
        }
        return new RecipeHolder(id, (Recipe)((CuttingRecipe)builder.build()));
    });
    public static final RecipeConverter<CuttingBoardRecipe, DeployerApplicationRecipe> DEPLOYING = RecipeConverter.cached((CacheBuilder)CacheBuilder.newBuilder(), holder -> {
        CuttingBoardRecipe recipe = (CuttingBoardRecipe)holder.value();
        ResourceLocation id = holder.id().withSuffix("_using_deployer");
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(DeployerApplicationRecipe::new, id).require((Ingredient)recipe.getIngredients().getFirst()).require(recipe.getTool());
        for (ChanceResult result : recipe.getRollableResults()) {
            builder.output(result.chance(), result.stack());
        }
        return new RecipeHolder(id, (Recipe)((DeployerApplicationRecipe)builder.build()));
    });

    @SubscribeEvent
    public static void onDeployerRecipeSearch(DeployerRecipeSearchEvent event) {
        if (((Boolean)CCKConfig.recipes().convertCuttingBoardRecipesToDeployingRecipes.get()).booleanValue()) {
            DeployerBlockEntity deployer = event.getBlockEntity();
            RecipeWrapper inventory = event.getInventory();
            Level level = deployer.getLevel();
            assert (level != null);
            event.addRecipe(() -> level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.CUTTING.get()).stream().filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(DEPLOYING).filter(holder -> ((DeployerApplicationRecipe)holder.value()).matches(inventory, level)).findFirst(), 50);
        }
    }
}

