/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.farmersdelight.mechanicalArm;

import com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.access.farmersdelight.StoveBlockEntityAccess;

public class StoveArmInteractionPoint
extends AllArmInteractionPointTypes.DepositOnlyArmInteractionPoint {
    public StoveArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof StoveBlockEntityAccess) {
            StoveBlockEntityAccess stove = (StoveBlockEntityAccess)blockEntity;
            int slot = stove.getNextEmptySlot();
            if (slot < 0 || slot >= stove.getInventory().getSlots() || stove.isStoveBlockedAbove()) {
                return stack;
            }
            Optional<RecipeHolder<CampfireCookingRecipe>> recipe = stove.getMatchingRecipe(stack);
            if (recipe.isEmpty()) {
                return stack;
            }
            ItemStack remainder = stack.copy();
            if (simulate) {
                remainder.shrink(1);
                return remainder;
            }
            stove.addItem(remainder, recipe.get(), slot);
            return remainder;
        }
        return stack;
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.upFromBottomCenterOf((Vec3i)this.pos, (double)1.0);
    }

    public static class Type
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.getBlockEntity(pos) instanceof StoveBlockEntityAccess;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new StoveArmInteractionPoint(this, level, pos, state);
        }
    }
}

