/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.client.burner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.util.CodeReference;

public interface BlazeBurnerRenderOverride {
    public boolean isValid(Level var1, BlockPos var2, BlazeBurnerBlockEntity var3);

    default public boolean isValidBlockAbove(boolean original) {
        return original;
    }

    default public PartialModel getBlazeModel(BlazeBurnerBlock.HeatLevel heatLevel, boolean active) {
        return BlazeBurnerRenderer.getBlazeModel((BlazeBurnerBlock.HeatLevel)heatLevel, (boolean)active);
    }

    default public PartialModel getSmallRodsModel(boolean superHeated) {
        return superHeated ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
    }

    default public PartialModel getLargeRodsModel(boolean superHeated) {
        return superHeated ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
    }

    default public SpriteShiftEntry getFlameSpriteShift(boolean superHeated) {
        return superHeated ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
    }

    default public ParticleOptions getFlameParticle(boolean superHeated) {
        return superHeated ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
    }

    @Nullable
    default public PartialModel getHatModel(boolean small) {
        return null;
    }

    @CodeReference(value={BlazeBurnerRenderer.class}, targets={"renderShared"}, source={"create"}, license={"mit"})
    default public void render(PoseStack poseStack, @Nullable PoseStack modelTransform, MultiBufferSource bufferSource, Level level, BlockState blockState, BlazeBurnerBlock.HeatLevel heatLevel, float animation, float horizontalAngle, boolean canDrawFlame, boolean drawGoggles, @Nullable PartialModel drawHat, int hashCode) {
        boolean superHeated;
        boolean blockAbove = animation > 0.125f;
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.sin((float)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float offset1 = Mth.sin((float)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
        float offset2 = Mth.sin((float)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
        float headY = offset - animation * 0.75f;
        poseStack.pushPose();
        PartialModel blazeModel = this.getBlazeModel(heatLevel, blockAbove);
        SuperByteBuffer blazeBuffer = CachedBuffers.partial((PartialModel)blazeModel, (BlockState)blockState);
        if (modelTransform != null) {
            blazeBuffer.transform(modelTransform);
        }
        blazeBuffer.translate(0.0f, headY, 0.0f);
        ((SuperByteBuffer)blazeBuffer.rotateCentered(horizontalAngle, Direction.UP)).light(0xF000F0).renderInto(poseStack, bufferSource.getBuffer(RenderType.solid()));
        boolean small = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        if (drawGoggles) {
            PartialModel gogglesModel = small ? AllPartialModels.BLAZE_GOGGLES : AllPartialModels.BLAZE_GOGGLES_SMALL;
            SuperByteBuffer gogglesBuffer = CachedBuffers.partial((PartialModel)gogglesModel, (BlockState)blockState);
            if (modelTransform != null) {
                gogglesBuffer.transform(modelTransform);
            }
            gogglesBuffer.translate(0.0f, headY + 0.5f, 0.0f);
            ((SuperByteBuffer)gogglesBuffer.rotateCentered(horizontalAngle, Direction.UP)).light(0xF000F0).renderInto(poseStack, bufferSource.getBuffer(RenderType.solid()));
        }
        if (drawHat == null) {
            drawHat = this.getHatModel(small);
        }
        if (drawHat != null) {
            SuperByteBuffer hatBuffer = CachedBuffers.partial((PartialModel)drawHat, (BlockState)blockState);
            if (modelTransform != null) {
                hatBuffer.transform(modelTransform);
            }
            hatBuffer.translate(0.0f, headY + 0.75f, 0.0f);
            ((SuperByteBuffer)((SuperByteBuffer)hatBuffer.rotateCentered(horizontalAngle + (float)Math.PI, Direction.UP)).translate(0.5f, 0.0f, 0.5f)).light(0xF000F0).renderInto(poseStack, bufferSource.getBuffer(RenderType.cutoutMipped()));
        }
        boolean bl = superHeated = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING;
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            PartialModel smallRodsModel = this.getSmallRodsModel(superHeated);
            PartialModel largeRodsModel = this.getLargeRodsModel(superHeated);
            SuperByteBuffer rodsBuffer = CachedBuffers.partial((PartialModel)smallRodsModel, (BlockState)blockState);
            if (modelTransform != null) {
                rodsBuffer.transform(modelTransform);
            }
            ((SuperByteBuffer)rodsBuffer.translate(0.0f, offset1 + animation + 0.125f, 0.0f)).light(0xF000F0).renderInto(poseStack, bufferSource.getBuffer(RenderType.solid()));
            SuperByteBuffer rodsBuffer2 = CachedBuffers.partial((PartialModel)largeRodsModel, (BlockState)blockState);
            if (modelTransform != null) {
                rodsBuffer2.transform(modelTransform);
            }
            ((SuperByteBuffer)rodsBuffer2.translate(0.0f, offset2 + animation - 0.1875f, 0.0f)).light(0xF000F0).renderInto(poseStack, bufferSource.getBuffer(RenderType.solid()));
        }
        if (canDrawFlame && blockAbove) {
            SpriteShiftEntry spriteShift = this.getFlameSpriteShift(superHeated);
            float spriteWidth = spriteShift.getTarget().getU1() - spriteShift.getTarget().getU0();
            float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
            float speed = 0.03125f + 0.015625f * (float)heatLevel.ordinal();
            double vScroll = speed * time;
            vScroll -= Math.floor(vScroll);
            vScroll = vScroll * (double)spriteHeight / 2.0;
            double uScroll = speed * time / 2.0f;
            uScroll -= Math.floor(uScroll);
            uScroll = uScroll * (double)spriteWidth / 2.0;
            SuperByteBuffer flameBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.BLAZE_BURNER_FLAME, (BlockState)blockState);
            if (modelTransform != null) {
                flameBuffer.transform(modelTransform);
            }
            flameBuffer.shiftUVScrolling(spriteShift, (float)uScroll, (float)vScroll);
            VertexConsumer cutout = bufferSource.getBuffer(RenderType.cutoutMipped());
            ((SuperByteBuffer)flameBuffer.rotateCentered(horizontalAngle, Direction.UP)).light(0xF000F0).renderInto(poseStack, cutout);
        }
        poseStack.popPose();
    }
}

