/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.feature;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import java.util.NoSuchElementException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class EntityFeature
implements MarkdownFeature {
    public String name() {
        return "entities";
    }

    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return compiler instanceof OwoUICompiler;
    }

    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<entity;")) {
                return false;
            }
            String entityString = nibbler.consumeUntil('>');
            if (entityString == null) {
                return false;
            }
            try {
                CompoundTag nbt = null;
                int nbtIndex = entityString.indexOf(123);
                if (nbtIndex != -1) {
                    nbt = new TagParser(new StringReader(entityString.substring(nbtIndex))).readStruct();
                    entityString = entityString.substring(0, nbtIndex);
                }
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)entityString)).orElseThrow();
                tokens.add(new EntityToken(entityString, entityType, nbt));
                return true;
            }
            catch (CommandSyntaxException | NoSuchElementException e) {
                return false;
            }
        }, '<');
    }

    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, entityToken, tokens) -> new EntityNode(entityToken.type, entityToken.nbt), (token, tokens) -> {
            EntityToken entity;
            return token instanceof EntityToken ? (entity = (EntityToken)((Object)token)) : null;
        });
    }

    private static class EntityToken
    extends Lexer.Token {
        public final EntityType<?> type;
        @Nullable
        public final CompoundTag nbt;

        public EntityToken(String content, EntityType<?> type, @Nullable CompoundTag nbt) {
            super(content);
            this.type = type;
            this.nbt = nbt;
        }
    }

    private static class EntityNode
    extends Parser.Node {
        public final EntityType<?> type;
        @Nullable
        public final CompoundTag nbt;

        public EntityNode(EntityType<?> type, @Nullable CompoundTag nbt) {
            this.type = type;
            this.nbt = nbt;
        }

        protected void visitStart(MarkdownCompiler<?> compiler) {
            ((OwoUICompiler)compiler).visitComponent((Component)Components.entity((Sizing)Sizing.fixed((int)32), this.type, (CompoundTag)this.nbt).scaleToFit(true));
        }

        protected void visitEnd(MarkdownCompiler<?> compiler) {
        }
    }
}

