/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class VillageStructures {
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        if (((Boolean)Configuration.GENERATE_VILLAGE_COMPOST_HEAPS.get()).booleanValue()) {
            Registry templatePools = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).get();
            Registry processorLists = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).get();
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/plains/houses"), "farmersdelight:village/houses/plains_compost_pile", 5);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/snowy/houses"), "farmersdelight:village/houses/snowy_compost_pile", 3);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/savanna/houses"), "farmersdelight:village/houses/savanna_compost_pile", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/desert/houses"), "farmersdelight:village/houses/desert_compost_pile", 3);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/taiga/houses"), "farmersdelight:village/houses/taiga_compost_pile", 4);
        }
        if (((Boolean)Configuration.GENERATE_VILLAGE_FARM_FD_CROPS.get()).booleanValue()) {
            Registry processorLists = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).orElseThrow();
            RuleProcessor temperateCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.CABBAGE_CROP.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.TOMATO_CROP.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.ONION_CROP.get().defaultBlockState())));
            RuleProcessor coldCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.CABBAGE_CROP.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.ONION_CROP.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.POTATOES, 0.2f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.CABBAGE_CROP.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.POTATOES, 0.2f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.ONION_CROP.get().defaultBlockState())));
            RuleProcessor aridCropProcessor = new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.CABBAGE_CROP.get().defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), (RuleTest)AlwaysTrueTest.INSTANCE, ModBlocks.TOMATO_CROP.get().defaultBlockState())));
            VillageStructures.addNewRuleToProcessorList(ResourceLocation.parse((String)"minecraft:farm_plains"), (StructureProcessor)temperateCropProcessor, (Registry<StructureProcessorList>)processorLists);
            VillageStructures.addNewRuleToProcessorList(ResourceLocation.parse((String)"minecraft:farm_savanna"), (StructureProcessor)aridCropProcessor, (Registry<StructureProcessorList>)processorLists);
            VillageStructures.addNewRuleToProcessorList(ResourceLocation.parse((String)"minecraft:farm_snowy"), (StructureProcessor)coldCropProcessor, (Registry<StructureProcessorList>)processorLists);
            VillageStructures.addNewRuleToProcessorList(ResourceLocation.parse((String)"minecraft:farm_taiga"), (StructureProcessor)temperateCropProcessor, (Registry<StructureProcessorList>)processorLists);
            VillageStructures.addNewRuleToProcessorList(ResourceLocation.parse((String)"minecraft:farm_desert"), (StructureProcessor)aridCropProcessor, (Registry<StructureProcessorList>)processorLists);
        }
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        ResourceLocation emptyProcessor = ResourceLocation.withDefaultNamespace((String)"empty");
        Holder.Reference processorHolder = processorListRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)emptyProcessor));
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, (Holder)processorHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    private static void addNewRuleToProcessorList(ResourceLocation targetProcessorList, StructureProcessor processorToAdd, Registry<StructureProcessorList> processorListRegistry) {
        processorListRegistry.getOptional(targetProcessorList).ifPresent(processorList -> {
            ArrayList<StructureProcessor> newSafeList = new ArrayList<StructureProcessor>(processorList.list());
            newSafeList.add(processorToAdd);
            processorList.list = newSafeList;
        });
    }
}

