/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.blaze3d.platform.ClipboardManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.lang.ClientFontHelper;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.createmod.catnip.render.DefaultSuperRenderTypeBuffer;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.registration.StoryBoardEntry;
import net.createmod.ponder.enums.PonderConfig;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.createmod.ponder.foundation.PonderChapter;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.PonderStoryBoardEntry;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.content.DebugScenes;
import net.createmod.ponder.foundation.element.TextWindowElement;
import net.createmod.ponder.foundation.ui.AbstractPonderScreen;
import net.createmod.ponder.foundation.ui.PonderButton;
import net.createmod.ponder.foundation.ui.PonderProgressBar;
import net.createmod.ponder.foundation.ui.PonderTagScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class PonderUI
extends AbstractPonderScreen {
    public static int ponderTicks;
    public static float ponderPartialTicksPaused;
    public static final Color BACKGROUND_TRANSPARENT;
    public static final Color BACKGROUND_FLAT;
    public static final Color BACKGROUND_IMPORTANT;
    public static final Couple<Color> COLOR_IDLE;
    public static final Couple<Color> COLOR_HOVER;
    public static final Couple<Color> COLOR_HIGHLIGHT;
    public static final Couple<Color> MISSING_VANILLA_ENTRY;
    public static final Couple<Color> MISSING_MODDED_ENTRY;
    private static final Vector3f DIFFUSE_LIGHT_0;
    private static final Vector3f DIFFUSE_LIGHT_1;
    private final List<PonderScene> scenes;
    private final List<PonderTag> tags;
    private List<PonderButton> tagButtons = new ArrayList<PonderButton>();
    private List<LerpedFloat> tagFades = new ArrayList<LerpedFloat>();
    private final LerpedFloat fadeIn;
    ItemStack stack;
    @Nullable
    PonderChapter chapter = null;
    private boolean userViewMode;
    private boolean identifyMode;
    private ItemStack hoveredTooltipItem = ItemStack.EMPTY;
    @Nullable
    private BlockPos hoveredBlockPos;
    private final ClipboardManager clipboardHelper;
    @Nullable
    private BlockPos copiedBlockPos;
    private final LerpedFloat finishingFlash;
    private final LerpedFloat nextUp;
    private int finishingFlashWarmup = 0;
    private int nextUpWarmup = 0;
    private final LerpedFloat lazyIndex;
    private int index = 0;
    @Nullable
    private PonderTag referredToByTag;
    private PonderButton left;
    private PonderButton right;
    private PonderButton scan;
    private PonderButton chap;
    private PonderButton userMode;
    private PonderButton close;
    private PonderButton replay;
    private PonderButton slowMode;
    private int skipCooling = 0;
    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(ResourceLocation id) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(id));
    }

    public static PonderUI of(ItemStack item) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(RegisteredObjectsHelper.getKeyOrThrow(item.getItem())));
    }

    public static PonderUI of(ItemStack item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderIndex.getSceneAccess().compile(RegisteredObjectsHelper.getKeyOrThrow(item.getItem())));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    protected PonderUI(List<PonderScene> scenes) {
        List<PonderScene> orderedScenes;
        ResourceLocation location = scenes.get(0).getLocation();
        this.stack = new ItemStack(RegisteredObjectsHelper.getItemOrBlock(location));
        this.tags = new ArrayList<PonderTag>(PonderIndex.getTagAccess().getTags(location));
        Ponder.LOGGER.debug("Ponder Scenes before ordering: {}", (Object)Arrays.toString(scenes.stream().map(PonderScene::getId).toArray()));
        try {
            orderedScenes = this.orderScenes(scenes);
            Ponder.LOGGER.debug("Ponder Scenes after ordering: {}", (Object)Arrays.toString(orderedScenes.stream().map(PonderScene::getId).toArray()));
        }
        catch (Exception e) {
            Ponder.LOGGER.warn("Unable to sort PonderScenes, using unordered List", (Throwable)e);
            orderedScenes = scenes;
        }
        this.scenes = orderedScenes;
        if (this.scenes.isEmpty()) {
            List<StoryBoardEntry> list = Collections.singletonList(new PonderStoryBoardEntry(DebugScenes::empty, "ponder", "debug/scene_1", ResourceLocation.withDefaultNamespace((String)"stick")));
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(list));
        }
        this.lazyIndex = LerpedFloat.linear().startWithValue(this.index);
        this.fadeIn = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.clipboardHelper = new ClipboardManager();
        this.finishingFlash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.nextUp = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.4f, LerpedFloat.Chaser.EXP);
    }

    private List<PonderScene> orderScenes(List<PonderScene> scenes) {
        Map<Boolean, List<PonderScene>> partitioned = scenes.stream().collect(Collectors.partitioningBy(scene -> scene.getOrderingEntries().isEmpty()));
        List<PonderScene> scenesWithOrdering = partitioned.get(false);
        List<PonderScene> scenesWithoutOrdering = partitioned.get(true);
        if (scenesWithOrdering.isEmpty()) {
            return scenes;
        }
        ArrayList<PonderScene> sceneList = new ArrayList<PonderScene>(scenes);
        Collections.reverse(sceneList);
        Map<ResourceLocation, PonderScene> sceneLookup = scenes.stream().collect(Collectors.toMap(PonderScene::getId, scene -> scene));
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        sceneList.forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        IntStream.range(1, scenesWithoutOrdering.size()).forEach(i -> graph.putEdge((Object)((PonderScene)scenesWithoutOrdering.get(i - 1)), (Object)((PonderScene)scenesWithoutOrdering.get(i))));
        scenesWithOrdering.forEach(scene -> {
            List<StoryBoardEntry.SceneOrderingEntry> relevantOrderings = scene.getOrderingEntries().stream().filter(entry -> scenes.stream().anyMatch(sc -> sc.getId().equals((Object)entry.sceneId()))).toList();
            if (relevantOrderings.isEmpty()) {
                return;
            }
            relevantOrderings.forEach(entry -> {
                PonderScene otherScene = (PonderScene)sceneLookup.get(entry.sceneId());
                if (entry.type() == StoryBoardEntry.SceneOrderingType.BEFORE) {
                    graph.putEdge(scene, (Object)otherScene);
                } else if (entry.type() == StoryBoardEntry.SceneOrderingType.AFTER) {
                    graph.putEdge((Object)otherScene, scene);
                }
            });
        });
        return PonderUI.topologicalSort((MutableGraph<PonderScene>)graph);
    }

    private static List<PonderScene> topologicalSort(MutableGraph<PonderScene> graph) {
        ArrayList<PonderScene> result = new ArrayList<PonderScene>();
        HashSet<PonderScene> visited = new HashSet<PonderScene>();
        HashSet<PonderScene> currentlyVisiting = new HashSet<PonderScene>();
        for (PonderScene node : graph.nodes()) {
            if (visited.contains(node) || PonderUI.dfs(node, graph, visited, currentlyVisiting, result)) continue;
            throw new IllegalArgumentException("Graph has a cycle!");
        }
        Collections.reverse(result);
        return result;
    }

    private static boolean dfs(PonderScene node, MutableGraph<PonderScene> graph, Set<PonderScene> visited, Set<PonderScene> currentlyVisiting, List<PonderScene> result) {
        if (currentlyVisiting.contains(node)) {
            return false;
        }
        if (!visited.contains(node)) {
            currentlyVisiting.add(node);
            for (PonderScene neighbor : graph.successors((Object)node)) {
                if (PonderUI.dfs(neighbor, graph, visited, currentlyVisiting, result)) continue;
                return false;
            }
            currentlyVisiting.remove(node);
            visited.add(node);
            result.add(node);
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.tagButtons = new ArrayList<PonderButton>();
        this.tagFades = new ArrayList<LerpedFloat>();
        this.tags.forEach(t -> {
            int i = this.tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;
            PonderButton b2 = (PonderButton)((AbstractSimiWidget)new PonderButton(x, y).showing((ScreenElement)t)).withCallback((mX, mY) -> {
                this.centerScalingOn((int)mX, (int)mY);
                ScreenOpener.transitionTo(new PonderTagScreen((PonderTag)t));
            });
            this.addRenderableWidget(b2);
            this.tagButtons.add(b2);
            LerpedFloat chase = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.05f, LerpedFloat.Chaser.exp(0.1));
            this.tagFades.add(chase);
        });
        Options bindings = this.minecraft.options;
        int spacing = 8;
        int bX = (this.width - 20) / 2 - (70 + 2 * spacing);
        int bY = this.height - 20 - 31;
        int pX = this.width / 2 - 110;
        int pY = bY + 20 + 4;
        int pW = this.width - 2 * pX;
        this.addRenderableWidget(new PonderProgressBar(this, pX, pY, pW, 1));
        this.scan = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX, bY).withShortcut(bindings.keyDrop)).showing(PonderGuiTextures.ICON_PONDER_IDENTIFY)).enableFade(0, 5)).withCallback(() -> {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            } else {
                ponderPartialTicksPaused = AnimationTickHolder.getPartialTicksUI();
            }
        });
        this.addRenderableWidget(this.scan);
        this.scan.atZLevel(600.0f);
        this.slowMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.width - 20 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_SLOW_MODE)).enableFade(0, 5)).withCallback(() -> this.setComfyReadingEnabled(!this.isComfyReadingEnabled()));
        this.addRenderableWidget(this.slowMode);
        if (PonderIndex.editingModeActive()) {
            this.userMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.width - 50 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_USER_MODE)).enableFade(0, 5)).withCallback(() -> {
                this.userViewMode = !this.userViewMode;
            });
            this.addRenderableWidget(this.userMode);
        }
        this.left = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.keyLeft)).showing(PonderGuiTextures.ICON_PONDER_LEFT)).enableFade(0, 5)).withCallback(() -> this.scroll(false));
        this.addRenderableWidget(this.left);
        this.close = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.keyInventory)).showing(PonderGuiTextures.ICON_PONDER_CLOSE)).enableFade(0, 5)).withCallback(this::onClose);
        this.addRenderableWidget(this.close);
        this.right = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.keyRight)).showing(PonderGuiTextures.ICON_PONDER_RIGHT)).enableFade(0, 5)).withCallback(() -> this.scroll(true));
        this.addRenderableWidget(this.right);
        this.replay = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.keyDown)).showing(PonderGuiTextures.ICON_PONDER_REPLAY)).enableFade(0, 5)).withCallback(this::replay);
        this.addRenderableWidget(this.replay);
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showingElement((RenderElement)GuiGameElement.of(this.stack).scale(1.5).at(-4.0f, -4.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.skipCooling > 0) {
            --this.skipCooling;
        }
        if (this.referredToByTag != null) {
            for (int i = 0; i < this.scenes.size(); ++i) {
                PonderScene ponderScene = this.scenes.get(i);
                if (!ponderScene.getTags().contains(this.referredToByTag)) continue;
                if (i == this.index) break;
                this.scenes.get(this.index).fadeOut();
                this.index = i;
                this.scenes.get(this.index).begin();
                this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
                this.identifyMode = false;
                break;
            }
            this.referredToByTag = null;
        }
        this.lazyIndex.tickChaser();
        this.fadeIn.tickChaser();
        this.finishingFlash.tickChaser();
        this.nextUp.tickChaser();
        PonderScene activeScene = this.scenes.get(this.index);
        this.extendedTickLength = 0;
        if (this.isComfyReadingEnabled()) {
            activeScene.forEachVisible(TextWindowElement.class, twe -> {
                this.extendedTickLength = 2;
            });
        }
        if (this.extendedTickTimer == 0) {
            float lazyIndexValue;
            if (!this.identifyMode) {
                ++ponderTicks;
                if (this.skipCooling == 0) {
                    activeScene.tick();
                }
            }
            if (!this.identifyMode && Math.abs((lazyIndexValue = this.lazyIndex.getValue()) - (float)this.index) > 0.001953125f) {
                this.scenes.get(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1).tick();
            }
            this.extendedTickTimer = this.extendedTickLength;
        } else {
            --this.extendedTickTimer;
        }
        if (activeScene.getCurrentTime() == activeScene.getTotalTime() - 1) {
            this.finishingFlashWarmup = 30;
            this.nextUpWarmup = 50;
        }
        if (this.finishingFlashWarmup > 0) {
            --this.finishingFlashWarmup;
            if (this.finishingFlashWarmup == 0) {
                this.finishingFlash.setValue(1.0);
                this.finishingFlash.setValue(1.0);
            }
        }
        if (this.nextUpWarmup > 0) {
            --this.nextUpWarmup;
            if (this.nextUpWarmup == 0) {
                this.nextUp.updateChaseTarget(1.0f);
            }
        }
        this.updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return this.scenes.get(this.index);
    }

    public void seekToTime(int time) {
        if (this.getActiveScene().getCurrentTime() > time) {
            this.replay();
        }
        this.getActiveScene().seekToTime(time);
        if (time != 0) {
            this.coolDownAfterSkip();
        }
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        this.hoveredTooltipItem = ItemStack.EMPTY;
        this.hoveredBlockPos = null;
        if (!this.identifyMode) {
            return;
        }
        Window w = this.minecraft.getWindow();
        double mouseX = this.minecraft.mouseHandler.xpos() * (double)w.getGuiScaledWidth() / (double)w.getScreenWidth();
        double mouseY = this.minecraft.mouseHandler.ypos() * (double)w.getGuiScaledHeight() / (double)w.getScreenHeight();
        PonderScene.SceneTransform t = activeScene.getTransform();
        Vec3 vec1 = t.screenToScene(mouseX, mouseY, 1000, 0.0f);
        Vec3 vec2 = t.screenToScene(mouseX, mouseY, -100, 0.0f);
        Pair<ItemStack, BlockPos> pair = activeScene.rayTraceScene(vec1, vec2);
        this.hoveredTooltipItem = pair.getFirst();
        this.hoveredBlockPos = pair.getSecond();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.scroll(scrollY > 0.0)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void replay() {
        this.identifyMode = false;
        PonderScene scene = this.scenes.get(this.index);
        if (PonderUI.hasShiftDown()) {
            PonderIndex.reload();
            this.scenes.clear();
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(scene.getLocation()));
        }
        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = this.index;
        this.index = forward ? this.index + 1 : this.index - 1;
        this.index = Mth.clamp((int)this.index, (int)0, (int)(this.scenes.size() - 1));
        if (prevIndex != this.index) {
            this.scenes.get(prevIndex).fadeOut();
            this.scenes.get(this.index).begin();
            this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
            this.identifyMode = false;
            return true;
        }
        this.index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        partialTicks = PonderUI.getPartialTicks();
        RenderSystem.enableBlend();
        this.renderVisibleScenes(graphics, mouseX, mouseY, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        this.renderWidgets(graphics, mouseX, mouseY, this.identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    protected void renderVisibleScenes(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScene(graphics, mouseX, mouseY, this.index, partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - (float)this.index) > 0.001953125f) {
            this.renderScene(graphics, mouseX, mouseY, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, partialTicks);
        }
    }

    protected void renderScene(GuiGraphics graphics, int mouseX, int mouseY, int i, float partialTicks) {
        DefaultSuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        PonderScene scene = this.scenes.get(i);
        double value = this.lazyIndex.getValue(AnimationTickHolder.getPartialTicksUI());
        double diff = (double)i - value;
        double slide = Mth.lerp((double)(diff * diff), (double)200.0, (double)600.0) * diff;
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.backupProjectionMatrix();
        PoseStack poseStack = graphics.pose();
        RenderSystem.setupLevelDiffuseLighting((Vector3f)DIFFUSE_LIGHT_0, (Vector3f)DIFFUSE_LIGHT_1);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        matrix4f.translate(0.0f, 0.0f, 800.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.DISTANCE_TO_ORIGIN);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, -800.0f);
        scene.getTransform().updateScreenParams(this.width, this.height, slide);
        scene.getTransform().apply(poseStack, partialTicks);
        scene.getTransform().updateSceneRVE(partialTicks);
        scene.renderScene(buffer, graphics, partialTicks);
        buffer.draw();
        BoundingBox bounds = scene.getBounds();
        poseStack.pushPose();
        if (!scene.shouldHidePlatformShadow()) {
            float flash;
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            poseStack.pushPose();
            poseStack.translate((float)scene.getBasePlateOffsetX(), 0.0f, (float)scene.getBasePlateOffsetZ());
            UIRenderHelper.flipForGuiRender(poseStack);
            float alpha = flash = this.finishingFlash.getValue(partialTicks) * 0.9f;
            flash *= flash;
            flash = flash * 2.0f - 1.0f;
            flash *= flash;
            flash = 1.0f - flash;
            for (int f = 0; f < 4; ++f) {
                poseStack.translate((float)scene.getBasePlateSize(), 0.0f, 0.0f);
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, -9.765625E-4f);
                if (flash > 0.0f) {
                    poseStack.pushPose();
                    poseStack.scale(1.0f, 0.5f + flash * 0.75f, 1.0f);
                    graphics.fillGradient(0, -1, -scene.getBasePlateSize(), 0, 0, new Color(13041609).getRGB(), new Color(-1429798967).scaleAlpha(alpha).getRGB());
                    poseStack.popPose();
                }
                poseStack.translate(0.0f, 0.0f, 0.001953125f);
                graphics.fillGradient(0, 0, -scene.getBasePlateSize(), 4, 0, new Color(0x66000000).getRGB(), new Color(0).getRGB());
                poseStack.popPose();
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
            poseStack.popPose();
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
        }
        if (PonderIndex.editingModeActive() && !this.userViewMode) {
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.scale(0.0625f, 0.0625f, 0.0625f);
            poseStack.translate(1.0f, -8.0f, -0.015625f);
            poseStack.pushPose();
            poseStack.translate(4.0f, -3.0f, 0.0f);
            poseStack.translate(0.0f, 0.0f, -0.001953125f);
            for (int x = 0; x <= bounds.getXSpan(); ++x) {
                poseStack.translate(-16.0f, 0.0f, 0.0f);
                graphics.drawString(this.font, (String)(x == bounds.getXSpan() ? "x" : "" + x), 0, 0, -1, false);
            }
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.scale(-1.0f, 1.0f, 1.0f);
            poseStack.translate(0.0f, -3.0f, -4.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            poseStack.translate(-8.0f, -2.0f, 0.03125f);
            for (int z = 0; z <= bounds.getZSpan(); ++z) {
                poseStack.translate(16.0f, 0.0f, 0.0f);
                graphics.drawString(this.font, (String)(z == bounds.getZSpan() ? "z" : "" + z), 0, 0, -1, false);
            }
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate((float)(bounds.getXSpan() * -8), 0.0f, (float)(bounds.getZSpan() * 8));
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            for (Direction d : Iterate.horizontalDirections) {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, (float)(bounds.getZSpan() * 16));
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                graphics.drawString(this.font, d.name().substring(0, 1), 0, 0, 0x66FFFFFF, false);
                graphics.drawString(this.font, "|", 2, 10, 0x44FFFFFF, false);
                graphics.drawString(this.font, ".", 2, 14, 0x22FFFFFF, false);
                poseStack.popPose();
            }
            poseStack.popPose();
            buffer.draw();
        }
        poseStack.popPose();
        poseStack.popPose();
        RenderSystem.restoreProjectionMatrix();
    }

    protected void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        float fade = this.fadeIn.getValue(partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        float indexDiff = lazyIndexValue - (float)this.index;
        PonderScene activeScene = this.scenes.get(this.index);
        PonderScene nextScene = this.scenes.size() > this.index + 1 ? this.scenes.get(this.index + 1) : null;
        boolean noWidgetsHovered = true;
        for (GuiEventListener child : this.children()) {
            noWidgetsHovered &= !child.isMouseOver((double)mouseX, (double)mouseY);
        }
        int tooltipColor = ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB();
        this.renderSceneInformation(graphics, fade, indexDiff, activeScene, tooltipColor);
        PoseStack ms = graphics.pose();
        if (this.identifyMode) {
            if (noWidgetsHovered && mouseY < this.height - 80) {
                ms.pushPose();
                ms.translate((float)mouseX, (float)mouseY, 100.0f);
                if (this.hoveredTooltipItem.isEmpty()) {
                    MutableComponent text = Ponder.lang().translate("ui.identify_mode", ((MutableComponent)this.minecraft.options.keyDrop.getTranslatedKeyMessage()).withStyle(ChatFormatting.WHITE)).style(ChatFormatting.GRAY).component();
                    graphics.renderComponentTooltip(this.font, this.font.getSplitter().splitLines((FormattedText)text, this.width / 3, Style.EMPTY).stream().map(t -> Component.literal((String)t.getString())).toList(), 0, 0);
                } else {
                    graphics.renderTooltip(this.font, this.hoveredTooltipItem, 0, 0);
                }
                if (this.hoveredBlockPos != null && PonderIndex.editingModeActive() && !this.userViewMode) {
                    ms.translate(0.0f, -15.0f, 0.0f);
                    boolean copied = this.hoveredBlockPos.equals((Object)this.copiedBlockPos);
                    MutableComponent coords = Component.literal((String)(this.hoveredBlockPos.getX() + ", " + this.hoveredBlockPos.getY() + ", " + this.hoveredBlockPos.getZ())).withStyle(copied ? ChatFormatting.GREEN : ChatFormatting.GOLD);
                    graphics.renderTooltip(this.font, (Component)coords, 0, 0);
                }
                ms.popPose();
            }
            this.scan.flash();
        } else {
            this.scan.dim();
        }
        if (PonderIndex.editingModeActive()) {
            if (this.userViewMode) {
                this.userMode.flash();
            } else {
                this.userMode.dim();
            }
        }
        if (this.isComfyReadingEnabled()) {
            this.slowMode.flash();
        } else {
            this.slowMode.dim();
        }
        this.renderSceneOverlay(graphics, partialTicks, lazyIndexValue, Math.abs(indexDiff));
        this.renderNextUp(graphics, partialTicks, nextScene);
        this.getRenderables().forEach(w -> {
            if (w instanceof PonderButton) {
                PonderButton button = (PonderButton)w;
                button.fade().startWithValue(fade);
            }
        });
        if (this.index == 0 || this.index == 1 && lazyIndexValue < (float)this.index) {
            this.left.fade().startWithValue(lazyIndexValue);
        }
        if (this.index == this.scenes.size() - 1 || this.index == this.scenes.size() - 2 && lazyIndexValue > (float)this.index) {
            this.right.fade().startWithValue((float)this.scenes.size() - lazyIndexValue - 1.0f);
        }
        if (activeScene.isFinished()) {
            this.right.flash();
        } else {
            this.right.dim();
            this.nextUp.updateChaseTarget(0.0f);
        }
        Color c1 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(64);
        Color c2 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(32);
        Color c3 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(16);
        UIRenderHelper.breadcrumbArrow(graphics, this.width / 2 - 20, this.height - 51, 0, 20, 20, 5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, this.width / 2 + 20, this.height - 51, 0, -20, 20, -5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, this.width / 2 - 90, this.height - 51, 0, 70, 20, 5, c1, c3);
        UIRenderHelper.breadcrumbArrow(graphics, this.width / 2 + 90, this.height - 51, 0, -70, 20, -5, c1, c3);
        List<PonderTag> sceneTags = activeScene.getTags();
        boolean highlightAll = sceneTags.stream().anyMatch(tag -> tag.getId() == PonderTag.Highlight.ALL);
        double s = Minecraft.getInstance().getWindow().getGuiScale();
        IntStream.range(0, this.tagButtons.size()).forEach(i -> {
            ms.pushPose();
            PonderTag tag = this.tags.get(i);
            LerpedFloat chase = this.tagFades.get(i);
            PonderButton button = this.tagButtons.get(i);
            if (button.isMouseOver(mouseX, mouseY)) {
                chase.updateChaseTarget(1.0f);
            } else {
                chase.updateChaseTarget(0.0f);
            }
            chase.tickChaser();
            if (highlightAll || sceneTags.contains(tag)) {
                button.flash();
            } else {
                button.dim();
            }
            int x = button.getX() + button.getWidth() + 4;
            int y = button.getY() - 2;
            ms.translate((float)x, (float)y + 5.0f * (1.0f - fade), 800.0f);
            float fadedWidth = 200.0f * chase.getValue(partialTicks);
            UIRenderHelper.streak(graphics, 0.0f, 0, 12, 26, (int)fadedWidth);
            RenderSystem.enableScissor((int)((int)((double)x * s)), (int)0, (int)((int)((double)fadedWidth * s)), (int)((int)((double)this.height * s)));
            String tagName = tag.getTitle();
            graphics.drawString(this.font, tagName, 3, 8, ((Color)UIRenderHelper.COLOR_TEXT_ACCENT.getFirst()).getRGB(), false);
            RenderSystem.disableScissor();
            ms.popPose();
        });
        this.renderHoverTooltips(graphics, tooltipColor);
        RenderSystem.enableDepthTest();
    }

    private void renderHoverTooltips(GuiGraphics graphics, int tooltipColor) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 500.0f);
        int tooltipY = this.height - 16;
        if (this.scan.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.identify", new Object[0]).component(), this.scan.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.index != 0 && this.left.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.previous", new Object[0]).component(), this.left.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.close.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.close", new Object[0]).component(), this.close.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.index != this.scenes.size() - 1 && this.right.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.next", new Object[0]).component(), this.right.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.replay.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.replay", new Object[0]).component(), this.replay.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.slowMode.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.slow_text", new Object[0]).component(), this.slowMode.getX() + 5, tooltipY, tooltipColor);
        }
        if (PonderIndex.editingModeActive() && this.userMode.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, "Editor View", this.userMode.getX() + 10, tooltipY, tooltipColor);
        }
        poseStack.popPose();
    }

    private void renderNextUp(GuiGraphics graphics, float partialTicks, @Nullable PonderScene nextScene) {
        if (!this.getActiveScene().isFinished()) {
            return;
        }
        if (nextScene == null || !nextScene.isNextUpEnabled()) {
            return;
        }
        if (!(this.nextUp.getValue() > 0.0625f)) {
            return;
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(this.right.getX() + 10), (float)(this.right.getY() - 6) + this.nextUp.getValue(partialTicks) * 5.0f, 400.0f);
        MutableComponent nextUpComponent = Ponder.lang().translate("ui.next_up", new Object[0]).component();
        int boxWidth = Math.max(this.font.width(nextScene.getTitle()), this.font.width((FormattedText)nextUpComponent)) + 5;
        PonderUI.renderSpeechBox(graphics, 0, 0, boxWidth, 20, this.right.isHoveredOrFocused(), Pointing.DOWN, false);
        poseStack.translate(0.0f, -29.0f, 100.0f);
        graphics.drawCenteredString(this.font, (Component)nextUpComponent, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB());
        graphics.drawCenteredString(this.font, nextScene.getTitle(), 0, 10, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.popPose();
    }

    private void renderSceneOverlay(GuiGraphics graphics, float partialTicks, float lazyIndexValue, float indexDiff) {
        float scenePT = this.skipCooling > 0 ? 0.0f : partialTicks;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        this.renderOverlay(graphics, this.index, scenePT);
        if (indexDiff > 0.001953125f) {
            this.renderOverlay(graphics, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, scenePT);
        }
        poseStack.popPose();
    }

    private void renderSceneInformation(GuiGraphics graphics, float fade, float indexDiff, PonderScene activeScene, int tooltipColor) {
        int otherTitleWidth;
        float indexOffset;
        float absoluteIndexDiff = Math.abs(indexDiff);
        int otherIndex = this.index;
        if (this.scenes.size() != 1 && (double)absoluteIndexDiff >= 0.01 && ((otherIndex = this.index + (int)(indexOffset = Math.signum(indexDiff))) < 0 || otherIndex >= this.scenes.size())) {
            return;
        }
        String title = activeScene.getTitle();
        String otherTitle = this.scenes.get(otherIndex).getTitle();
        int maxTitleWidth = 180;
        int titleWidth = this.font.width(title);
        if (titleWidth > maxTitleWidth) {
            titleWidth = maxTitleWidth;
        }
        if ((otherTitleWidth = this.font.width(otherTitle)) > maxTitleWidth) {
            otherTitleWidth = maxTitleWidth;
        }
        int wrappedTitleHeight = this.font.wordWrapHeight(title, maxTitleWidth);
        int otherWrappedTitleHeight = this.font.wordWrapHeight(otherTitle, maxTitleWidth);
        int streakHeight = 26 + (int)Mth.lerp((float)absoluteIndexDiff, (float)wrappedTitleHeight, (float)otherWrappedTitleHeight);
        int streakWidth = 70 + (int)Mth.lerp((float)absoluteIndexDiff, (float)titleWidth, (float)otherTitleWidth);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 400.0f);
        poseStack.translate(55.0f, 19.0f, 0.0f);
        UIRenderHelper.streak(graphics, 0.0f, 0, streakHeight / 2, streakHeight, (int)((float)streakWidth * fade));
        UIRenderHelper.streak(graphics, 180.0f, 0, streakHeight / 2, streakHeight, (int)(30.0f * fade));
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BACKGROUND_FLAT)).gradientBorder(COLOR_IDLE)).at(-34.0f, 2.0f, 100.0f).withBounds(30, 30).render(graphics);
        GuiGameElement.of(this.stack).scale(2.0).at(-35.0f, 1.0f).render(graphics);
        poseStack.translate(4.0f, 6.0f, 0.0f);
        graphics.drawString(this.font, (Component)Ponder.lang().translate("ui.pondering", new Object[0]).component(), 0, 0, tooltipColor, false);
        poseStack.translate(0.0f, 14.0f, 0.0f);
        if (this.scenes.size() == 1 || (double)absoluteIndexDiff < 0.01) {
            ClientFontHelper.drawSplitString(graphics, poseStack, this.font, title, 0, 0, maxTitleWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(fade).getRGB());
            poseStack.popPose();
            return;
        }
        poseStack.translate(0.0f, 6.0f, 0.0f);
        poseStack.pushPose();
        poseStack.mulPose(Axis.XN.rotationDegrees(indexDiff * -90.0f + Math.signum(indexDiff) * 90.0f));
        poseStack.translate(0.0f, -6.0f, 5.0f);
        ClientFontHelper.drawSplitString(graphics, poseStack, this.font, otherTitle, 0, 0, maxTitleWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(absoluteIndexDiff).getRGB());
        poseStack.popPose();
        poseStack.mulPose(Axis.XN.rotationDegrees(indexDiff * -90.0f));
        poseStack.translate(0.0f, -6.0f, 5.0f);
        ClientFontHelper.drawSplitString(graphics, poseStack, this.font, title, 0, 0, maxTitleWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(1.0f - absoluteIndexDiff).getRGB());
        poseStack.popPose();
    }

    private void renderOverlay(GuiGraphics graphics, int i, float partialTicks) {
        if (this.identifyMode) {
            return;
        }
        graphics.pose().pushPose();
        PonderScene story = this.scenes.get(i);
        story.renderOverlay(this, graphics, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        graphics.pose().popPose();
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.identifyMode && this.hoveredBlockPos != null && PonderIndex.editingModeActive()) {
            long handle = this.minecraft.getWindow().getWindow();
            if (this.copiedBlockPos != null && button == 1) {
                this.clipboardHelper.setClipboard(handle, "util.select().fromTo(" + this.copiedBlockPos.getX() + ", " + this.copiedBlockPos.getY() + ", " + this.copiedBlockPos.getZ() + ", " + this.hoveredBlockPos.getX() + ", " + this.hoveredBlockPos.getY() + ", " + this.hoveredBlockPos.getZ() + ")");
                this.copiedBlockPos = this.hoveredBlockPos;
                return true;
            }
            if (PonderUI.hasShiftDown()) {
                this.clipboardHelper.setClipboard(handle, "util.select().position(" + this.hoveredBlockPos.getX() + ", " + this.hoveredBlockPos.getY() + ", " + this.hoveredBlockPos.getZ() + ")");
            } else {
                this.clipboardHelper.setClipboard(handle, "util.grid().at(" + this.hoveredBlockPos.getX() + ", " + this.hoveredBlockPos.getY() + ", " + this.hoveredBlockPos.getZ() + ")");
            }
            this.copiedBlockPos = this.hoveredBlockPos;
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (this.chapter != null) {
            return this.chapter.getTitle();
        }
        return this.stack.getItem().getDescription().getString();
    }

    public Font getFontRenderer() {
        return this.font;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < (double)x) && !(mouseX > (double)(x + w));
        return hovered &= !(mouseY < (double)y) && !(mouseY > (double)(y + h));
    }

    public static void renderSpeechBox(GuiGraphics graphics, int x, int y, int w, int h, boolean highlighted, Pointing pointing, boolean returnWithLocalTransform) {
        PoseStack poseStack = graphics.pose();
        if (!returnWithLocalTransform) {
            poseStack.pushPose();
        }
        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotRotation = 0;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        Couple<Color> borderColors = highlighted ? PonderButton.COLOR_HOVER : COLOR_IDLE;
        Color c = switch (pointing) {
            default -> {
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                yield (Color)borderColors.getSecond();
            }
            case Pointing.LEFT -> {
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.RIGHT -> {
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.UP -> {
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
                yield (Color)borderColors.getFirst();
            }
        };
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BACKGROUND_FLAT)).gradientBorder(borderColors)).at(boxX, boxY, 100.0f).withBounds(w, h).render(graphics);
        poseStack.pushPose();
        poseStack.translate((float)(divotX + divotRadius), (float)(divotY + divotRadius), 110.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)divotRotation));
        poseStack.translate((float)(-divotRadius), (float)(-divotRadius), 0.0f);
        PonderGuiTextures.SPEECH_TOOLTIP_BACKGROUND.render(graphics, 0, 0);
        PonderGuiTextures.SPEECH_TOOLTIP_COLOR.render(graphics, 0, 0, c);
        poseStack.popPose();
        if (returnWithLocalTransform) {
            poseStack.translate((float)boxX, (float)boxY, 0.0f);
            return;
        }
        poseStack.popPose();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredTooltipItem;
    }

    public ItemStack getSubject() {
        return this.stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI otherUI = (PonderUI)other;
            return !otherUI.stack.isEmpty() && this.stack.is(otherUI.stack.getItem());
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI ponderUI = (PonderUI)other;
            ponderUI.referredToByTag = this.referredToByTag;
        }
    }

    public static float getPartialTicks() {
        float renderPartialTicks = AnimationTickHolder.getPartialTicksUI();
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof PonderUI) {
            PonderUI ui = (PonderUI)screen;
            if (ui.identifyMode) {
                return ponderPartialTicksPaused;
            }
            return (renderPartialTicks + (float)(ui.extendedTickLength - ui.extendedTickTimer)) / (float)(ui.extendedTickLength + 1);
        }
        return renderPartialTicks;
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    public void coolDownAfterSkip() {
        this.skipCooling = 15;
    }

    public void removed() {
        super.removed();
        this.hoveredTooltipItem = ItemStack.EMPTY;
    }

    public boolean isComfyReadingEnabled() {
        return (Boolean)PonderConfig.client().comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        PonderConfig.client().comfyReading.set(slowTextMode);
    }

    static {
        BACKGROUND_TRANSPARENT = new Color(-587202560, true);
        BACKGROUND_FLAT = new Color(-16777216, true);
        BACKGROUND_IMPORTANT = new Color(-586281440, true);
        COLOR_IDLE = Couple.create(new Color(1090514653, true), new Color(553643741, true)).map(Color::setImmutable);
        COLOR_HOVER = Couple.create(new Color(0x70FFFFFF, true), new Color(0x30FFFFFF, true)).map(Color::setImmutable);
        COLOR_HIGHLIGHT = Couple.create(new Color(-251662627, true), new Color(1627385565, true)).map(Color::setImmutable);
        MISSING_VANILLA_ENTRY = Couple.create(new Color(0x505000FF, true), new Color(1344798847, true)).map(Color::setImmutable);
        MISSING_MODDED_ENTRY = Couple.create(new Color(1889027328, true), new Color(1885938688, true)).map(Color::setImmutable);
        DIFFUSE_LIGHT_0 = new Vector3f(0.4f, -1.0f, 0.7f).normalize();
        DIFFUSE_LIGHT_1 = new Vector3f(-0.4f, -0.5f, 0.7f).normalize();
    }
}

