/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.registration;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.registration.SceneRegistryAccess;
import net.createmod.ponder.api.registration.StoryBoardEntry;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.registration.PonderLocalization;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PonderSceneRegistry
implements SceneRegistryAccess {
    private final PonderLocalization localization;
    private final Multimap<ResourceLocation, StoryBoardEntry> scenes;
    private boolean allowRegistration = true;

    public PonderSceneRegistry(PonderLocalization localization) {
        this.localization = localization;
        this.scenes = LinkedHashMultimap.create();
    }

    public void clearRegistry() {
        this.scenes.clear();
        this.allowRegistration = true;
    }

    public void addStoryBoard(StoryBoardEntry entry) {
        if (!this.allowRegistration) {
            throw new IllegalStateException("Registration Phase has already ended!");
        }
        this.scenes.put((Object)entry.getComponent(), (Object)entry);
    }

    @Override
    public Collection<Map.Entry<ResourceLocation, StoryBoardEntry>> getRegisteredEntries() {
        return this.scenes.entries();
    }

    @Override
    public boolean doScenesExistForId(ResourceLocation id) {
        return this.scenes.containsKey((Object)id);
    }

    @Override
    public List<PonderScene> compile(ResourceLocation id) {
        Collection entries;
        if (PonderIndex.editingModeActive()) {
            PonderIndex.reload();
        }
        if ((entries = this.scenes.get((Object)id)).isEmpty()) {
            return Collections.emptyList();
        }
        return this.compile(entries);
    }

    @Override
    public List<PonderScene> compile(Collection<StoryBoardEntry> entries) {
        if (PonderIndex.editingModeActive()) {
            this.localization.clearShared();
            PonderIndex.gatherSharedText();
        }
        ArrayList<PonderScene> scenes = new ArrayList<PonderScene>();
        for (StoryBoardEntry storyBoard : entries) {
            StructureTemplate activeTemplate = PonderSceneRegistry.loadSchematic(storyBoard.getSchematicLocation());
            PonderLevel level = new PonderLevel(BlockPos.ZERO, (Level)Minecraft.getInstance().level);
            activeTemplate.placeInWorld((ServerLevelAccessor)level, BlockPos.ZERO, BlockPos.ZERO, new StructurePlaceSettings(), level.random, 2);
            level.createBackup();
            PonderScene scene = PonderSceneRegistry.compileScene(this.localization, storyBoard, level);
            scene.begin();
            scenes.add(scene);
        }
        return scenes;
    }

    public static PonderScene compileScene(PonderLocalization localization, StoryBoardEntry sb, @Nullable PonderLevel level) {
        PonderScene scene = new PonderScene(level, localization, sb.getNamespace(), sb.getComponent(), sb.getTags(), sb.getOrderingEntries());
        SceneBuilder builder = scene.builder();
        sb.getBoard().program(builder, scene.getSceneBuildingUtil());
        return scene;
    }

    public static StructureTemplate loadSchematic(ResourceLocation location) {
        return PonderSceneRegistry.loadSchematic(Minecraft.getInstance().getResourceManager(), location);
    }

    public static StructureTemplate loadSchematic(ResourceManager resourceManager, ResourceLocation location) {
        StructureTemplate structureTemplate;
        block9: {
            String path;
            String namespace = location.getNamespace();
            ResourceLocation location1 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(path = "ponder/" + location.getPath() + ".nbt"));
            Optional optionalResource = resourceManager.getResource(location1);
            if (optionalResource.isEmpty()) {
                Ponder.LOGGER.error("Ponder schematic missing: " + String.valueOf(location1));
                return new StructureTemplate();
            }
            Resource resource = (Resource)optionalResource.get();
            InputStream inputStream = resource.open();
            try {
                structureTemplate = PonderSceneRegistry.loadSchematic(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Ponder.LOGGER.error("Failed to read ponder schematic: " + String.valueOf(location1), (Throwable)e);
                    return new StructureTemplate();
                }
            }
            inputStream.close();
        }
        return structureTemplate;
    }

    public static StructureTemplate loadSchematic(InputStream resourceStream) throws IOException {
        StructureTemplate t = new StructureTemplate();
        DataInputStream stream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(resourceStream)));
        CompoundTag nbt = NbtIo.read((DataInput)stream, (NbtAccounter)NbtAccounter.create((long)0x20000000L));
        t.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), nbt);
        return t;
    }
}

