/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.catnip.data.Couple;
import net.createmod.ponder.api.registration.LangRegistryAccess;
import net.createmod.ponder.api.registration.StoryBoardEntry;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.registration.PonderSceneRegistry;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class PonderLocalization
implements LangRegistryAccess {
    public static final String LANG_PREFIX = "ponder.";
    public static final String UI_PREFIX = "ui.";
    public final Map<ResourceLocation, String> shared = new HashMap<ResourceLocation, String>();
    public final Map<ResourceLocation, Couple<String>> tag = new HashMap<ResourceLocation, Couple<String>>();
    public final Map<ResourceLocation, Map<String, String>> specific = new HashMap<ResourceLocation, Map<String, String>>();

    public void clearAll() {
        this.shared.clear();
        this.tag.clear();
        this.specific.clear();
    }

    public void clearShared() {
        this.shared.clear();
    }

    public void registerShared(ResourceLocation key, String enUS) {
        this.shared.put(key, enUS);
    }

    public void registerTag(ResourceLocation key, String title, String description) {
        this.tag.put(key, Couple.create(title, description));
    }

    public void registerSpecific(ResourceLocation sceneId, String key, String enUS) {
        this.specific.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    protected static String langKeyForShared(ResourceLocation k) {
        return k.getNamespace() + ".ponder.shared." + k.getPath();
    }

    protected static String langKeyForTag(ResourceLocation k) {
        return k.getNamespace() + ".ponder.tag." + k.getPath();
    }

    protected static String langKeyForTagDescription(ResourceLocation k) {
        return k.getNamespace() + ".ponder.tag." + k.getPath() + ".description";
    }

    protected static String langKeyForSpecific(ResourceLocation sceneId, String k) {
        return sceneId.getNamespace() + ".ponder." + sceneId.getPath() + "." + k;
    }

    @Override
    public String getShared(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return this.shared.containsKey(key) ? this.shared.get(key) : "unregistered shared entry: " + String.valueOf(key);
        }
        return I18n.get((String)PonderLocalization.langKeyForShared(key), (Object[])new Object[0]);
    }

    @Override
    public String getTagName(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return this.tag.containsKey(key) ? (String)this.tag.get(key).getFirst() : "unregistered tag entry: " + String.valueOf(key);
        }
        return I18n.get((String)PonderLocalization.langKeyForTag(key), (Object[])new Object[0]);
    }

    @Override
    public String getTagDescription(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return this.tag.containsKey(key) ? (String)this.tag.get(key).getSecond() : "unregistered tag entry: " + String.valueOf(key);
        }
        return I18n.get((String)PonderLocalization.langKeyForTagDescription(key), (Object[])new Object[0]);
    }

    @Override
    public String getSpecific(ResourceLocation sceneId, String k) {
        if (PonderIndex.editingModeActive()) {
            try {
                return this.specific.get(sceneId).get(k);
            }
            catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        }
        return I18n.get((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])new Object[0]);
    }

    private void recordGeneral(BiConsumer<String, String> consumer) {
        this.addGeneral(consumer, "ui.hold_to_ponder", "Hold [%1$s] to Ponder");
        this.addGeneral(consumer, "ui.subject", "Subject of this scene");
        this.addGeneral(consumer, "ui.pondering", "Pondering about...");
        this.addGeneral(consumer, "ui.identify_mode", "Identify mode active.\nUnpause with [%1$s]");
        this.addGeneral(consumer, "ui.associated", "Associated Entries");
        this.addGeneral(consumer, "ui.close", "Close");
        this.addGeneral(consumer, "ui.identify", "Identify");
        this.addGeneral(consumer, "ui.next", "Next Scene");
        this.addGeneral(consumer, "ui.next_up", "Up Next:");
        this.addGeneral(consumer, "ui.previous", "Previous Scene");
        this.addGeneral(consumer, "ui.replay", "Replay");
        this.addGeneral(consumer, "ui.think_back", "Think Back");
        this.addGeneral(consumer, "ui.slow_text", "Comfy Reading");
        this.addGeneral(consumer, "ui.exit", "Exit");
        this.addGeneral(consumer, "ui.welcome", "Welcome to Ponder");
        this.addGeneral(consumer, "ui.categories", "Available Categories for %1$s");
        this.addGeneral(consumer, "ui.index_description", "Click one of the icons below to learn about its associated Items and Blocks");
        this.addGeneral(consumer, "ui.index_title", "Ponder Index");
    }

    private void addGeneral(BiConsumer<String, String> consumer, String key, String enUS) {
        consumer.accept(LANG_PREFIX + key, enUS);
    }

    public void generateSceneLang() {
        PonderIndex.getSceneAccess().getRegisteredEntries().forEach(entry -> PonderSceneRegistry.compileScene(this, (StoryBoardEntry)entry.getValue(), null));
    }

    @Override
    public void provideLang(String modId, BiConsumer<String, String> consumer) {
        PonderIndex.registerAll();
        PonderIndex.gatherSharedText();
        this.generateSceneLang();
        if (modId.equals("ponder")) {
            this.recordGeneral(consumer);
        }
        this.shared.forEach((k, v) -> {
            if (k.getNamespace().equals(modId)) {
                consumer.accept(PonderLocalization.langKeyForShared(k), (String)v);
            }
        });
        this.tag.forEach((k, v) -> {
            if (k.getNamespace().equals(modId)) {
                consumer.accept(PonderLocalization.langKeyForTag(k), (String)v.getFirst());
                consumer.accept(PonderLocalization.langKeyForTagDescription(k), (String)v.getSecond());
            }
        });
        this.specific.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equals(modId)).sorted(Map.Entry.comparingByKey()).forEach(entry -> ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(subEntry -> consumer.accept(PonderLocalization.langKeyForSpecific((ResourceLocation)entry.getKey(), (String)subEntry.getKey()), (String)subEntry.getValue())));
    }
}

