/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.registration;

import java.util.List;
import java.util.function.Function;
import net.createmod.ponder.api.registration.MultiTagBuilder;
import net.createmod.ponder.api.registration.PonderTagRegistrationHelper;
import net.createmod.ponder.api.registration.TagBuilder;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.registration.GenericMultiTagBuilder;
import net.createmod.ponder.foundation.registration.GenericPonderTagRegistrationHelper;
import net.createmod.ponder.foundation.registration.PonderLocalization;
import net.createmod.ponder.foundation.registration.PonderTagBuilder;
import net.createmod.ponder.foundation.registration.PonderTagRegistry;
import net.minecraft.resources.ResourceLocation;

public class DefaultPonderTagRegistrationHelper
implements PonderTagRegistrationHelper<ResourceLocation> {
    protected String namespace;
    protected PonderTagRegistry tagRegistry;
    protected PonderLocalization localization;

    public DefaultPonderTagRegistrationHelper(String namespace, PonderTagRegistry tagRegistry, PonderLocalization localization) {
        this.namespace = namespace;
        this.tagRegistry = tagRegistry;
        this.localization = localization;
    }

    @Override
    public <T> PonderTagRegistrationHelper<T> withKeyFunction(Function<T, ResourceLocation> keyGen) {
        return new GenericPonderTagRegistrationHelper<T>(this, keyGen);
    }

    @Override
    public TagBuilder registerTag(ResourceLocation location) {
        return new PonderTagBuilder(location, this::finishTagRegister);
    }

    @Override
    public TagBuilder registerTag(String id) {
        return new PonderTagBuilder(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)id), this::finishTagRegister);
    }

    private void finishTagRegister(PonderTagBuilder builder) {
        this.localization.registerTag(builder.id, builder.title, builder.description);
        PonderTag tag = new PonderTag(builder.id, builder.textureIconLocation, builder.itemIcon, builder.mainItem);
        this.tagRegistry.registerTag(tag);
        if (builder.addToIndex) {
            this.tagRegistry.listTag(tag);
        }
    }

    @Override
    public void addTagToComponent(ResourceLocation component, ResourceLocation tag) {
        this.tagRegistry.addTagToComponent(tag, component);
    }

    @Override
    public MultiTagBuilder.Tag<ResourceLocation> addToTag(ResourceLocation tag) {
        return new GenericMultiTagBuilder.Tag(new GenericMultiTagBuilder(), this, List.of(tag));
    }

    @Override
    public MultiTagBuilder.Tag<ResourceLocation> addToTag(ResourceLocation ... tags) {
        return new GenericMultiTagBuilder.Tag(new GenericMultiTagBuilder(), this, List.of(tags));
    }

    @Override
    public MultiTagBuilder.Component addToComponent(ResourceLocation component) {
        return new GenericMultiTagBuilder.Component(new GenericMultiTagBuilder(), this, List.of(component));
    }

    @Override
    public MultiTagBuilder.Component addToComponent(ResourceLocation ... components) {
        return new GenericMultiTagBuilder.Component(new GenericMultiTagBuilder(), this, List.of(components));
    }
}

