/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.TextElementBuilder;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.AnimatedOverlayElementBase;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TextWindowElement
extends AnimatedOverlayElementBase {
    public static final Couple<Color> COLOR_WINDOW_BORDER = Couple.create(new Color(1618632704, true), new Color(544890880, true)).map(Color::setImmutable);
    Supplier<String> textGetter = () -> "(?) No text was provided";
    @Nullable
    String bakedText;
    int y;
    @Nullable
    Vec3 vec;
    boolean nearScene = false;
    PonderPalette palette = PonderPalette.WHITE;

    public TextElementBuilder builder(PonderScene scene) {
        return new Builder(scene);
    }

    @Override
    public void render(PonderScene scene, PonderUI screen, GuiGraphics graphics, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        PonderScene.SceneTransform transform = scene.getTransform();
        Vec2 sceneToScreen = this.vec != null ? transform.sceneToScreen(this.vec, partialTicks) : new Vec2((float)screen.width / 2.0f, (float)(screen.height - 200) / 2.0f + (float)this.y - 8.0f);
        boolean settled = transform.xRotation.settled() && transform.yRotation.settled();
        float pY = settled ? (float)((int)sceneToScreen.y) : sceneToScreen.y;
        float yDiff = ((float)screen.height / 2.0f - sceneToScreen.y - 10.0f) / 100.0f;
        float targetX = (float)screen.width * Mth.lerp((float)(yDiff * yDiff), (float)0.75f, (float)0.625f);
        if (this.nearScene) {
            targetX = Math.min(targetX, sceneToScreen.x + 50.0f);
        }
        if (settled) {
            targetX = (int)targetX;
        }
        int textWidth = (int)Math.min((float)screen.width - targetX, 180.0f);
        List lines = screen.getFontRenderer().getSplitter().splitLines(this.bakedText, textWidth, Style.EMPTY);
        int boxWidth = 0;
        for (FormattedText line : lines) {
            boxWidth = Math.max(boxWidth, screen.getFontRenderer().width(line));
        }
        int boxHeight = screen.getFontRenderer().wordWrapHeight(this.bakedText, boxWidth);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, pY, 400.0f);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(COLOR_WINDOW_BORDER)).at(targetX - 10.0f, 3.0f, -101.0f).withBounds(boxWidth, boxHeight - 1).render(graphics);
        Color brighter = this.palette.getColorObject().mixWith(new Color(-35), 0.5f).setImmutable();
        Color c1 = new Color(-11974327);
        Color c2 = new Color(-13027015);
        if (this.vec != null) {
            poseStack.pushPose();
            poseStack.translate(sceneToScreen.x, 0.0f, 0.0f);
            double lineTarget = (targetX - sceneToScreen.x) * fade;
            poseStack.scale((float)lineTarget, 1.0f, 1.0f);
            graphics.fillGradient(0, 0, 1, 1, -100, brighter.getRGB(), brighter.getRGB());
            graphics.fillGradient(0, 1, 1, 2, -100, c1.getRGB(), c2.getRGB());
            poseStack.popPose();
        }
        poseStack.translate(0.0f, 0.0f, 400.0f);
        for (int i = 0; i < lines.size(); ++i) {
            graphics.drawString(screen.getFontRenderer(), ((FormattedText)lines.get(i)).getString(), (int)(targetX - 10.0f), 3 + 9 * i, brighter.scaleAlphaForText(fade).getRGB(), false);
        }
        poseStack.popPose();
    }

    public PonderPalette getPalette() {
        return this.palette;
    }

    private class Builder
    implements TextElementBuilder {
        private final PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        @Override
        public Builder colored(PonderPalette color) {
            TextWindowElement.this.palette = color;
            return this;
        }

        @Override
        public Builder pointAt(Vec3 vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        @Override
        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        @Override
        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        @Override
        public Builder sharedText(ResourceLocation key) {
            TextWindowElement.this.textGetter = () -> PonderIndex.getLangAccess().getShared(key);
            return this;
        }

        @Override
        public Builder sharedText(String key) {
            return this.sharedText(ResourceLocation.fromNamespaceAndPath((String)this.scene.getNamespace(), (String)key));
        }

        @Override
        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        @Override
        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

