/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SelectionImpl {
    public static Selection of(BoundingBox bb) {
        return new Simple(bb);
    }

    private static class Simple
    implements Selection {
        private final BoundingBox bb;
        private final AABB aabb;

        public Simple(BoundingBox bb) {
            this.bb = bb;
            this.aabb = this.getAABB();
        }

        @Override
        public boolean test(BlockPos t) {
            return this.bb.isInside((Vec3i)t);
        }

        @Override
        public Selection add(Selection other) {
            return new Compound(this).add(other);
        }

        @Override
        public Selection substract(Selection other) {
            return new Compound(this).substract(other);
        }

        @Override
        public void forEach(Consumer<BlockPos> callback) {
            BlockPos.betweenClosedStream((BoundingBox)this.bb).forEach(callback);
        }

        @Override
        public Vec3 getCenter() {
            return this.aabb.getCenter();
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showAABB(slot, this.aabb);
        }

        private AABB getAABB() {
            return new AABB((double)this.bb.minX(), (double)this.bb.minY(), (double)this.bb.minZ(), (double)(this.bb.maxX() + 1), (double)(this.bb.maxY() + 1), (double)(this.bb.maxZ() + 1));
        }

        @Override
        public Selection copy() {
            return new Simple(new BoundingBox(this.bb.minX(), this.bb.minY(), this.bb.minZ(), this.bb.maxX(), this.bb.maxY(), this.bb.maxZ()));
        }
    }

    private static class Compound
    implements Selection {
        Set<BlockPos> posSet;
        @Nullable
        Vec3 center;

        public Compound(Simple initial) {
            this.posSet = new HashSet<BlockPos>();
            this.add(initial);
        }

        private Compound(Set<BlockPos> template) {
            this.posSet = new HashSet<BlockPos>(template);
        }

        @Override
        public boolean test(BlockPos t) {
            return this.posSet.contains(t);
        }

        @Override
        public Selection add(Selection other) {
            other.forEach(p -> this.posSet.add(p.immutable()));
            this.center = null;
            return this;
        }

        @Override
        public Selection substract(Selection other) {
            other.forEach(p -> this.posSet.remove(p.immutable()));
            this.center = null;
            return this;
        }

        @Override
        public void forEach(Consumer<BlockPos> callback) {
            this.posSet.forEach(callback);
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showCluster(slot, this.posSet);
        }

        @Override
        public Vec3 getCenter() {
            return this.center == null ? (this.center = this.evalCenter()) : this.center;
        }

        private Vec3 evalCenter() {
            Vec3 center = Vec3.ZERO;
            if (this.posSet.isEmpty()) {
                return center;
            }
            for (BlockPos blockPos : this.posSet) {
                center = center.add(Vec3.atLowerCornerOf((Vec3i)blockPos));
            }
            center = center.scale((double)(1.0f / (float)this.posSet.size()));
            return center.add(new Vec3(0.5, 0.5, 0.5));
        }

        @Override
        public Selection copy() {
            return new Compound(this.posSet);
        }
    }
}

