/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class PonderWorldParticles {
    private final Map<ParticleRenderType, Queue<Particle>> byType = Maps.newIdentityHashMap();
    private final Queue<Particle> queue = Queues.newArrayDeque();
    PonderLevel world;

    public PonderWorldParticles(PonderLevel world) {
        this.world = world;
    }

    public void addParticle(Particle p) {
        this.queue.add(p);
    }

    public void tick() {
        Particle particle;
        this.byType.forEach((p_228347_1_, p_228347_2_) -> this.tickParticleList((Collection<Particle>)p_228347_2_));
        if (this.queue.isEmpty()) {
            return;
        }
        while ((particle = this.queue.poll()) != null) {
            this.byType.computeIfAbsent(particle.getRenderType(), $ -> EvictingQueue.create((int)16384)).add(particle);
        }
    }

    private void tickParticleList(Collection<Particle> p_187240_1_) {
        if (p_187240_1_.isEmpty()) {
            return;
        }
        Iterator<Particle> iterator = p_187240_1_.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            particle.tick();
            if (particle.isAlive()) continue;
            iterator.remove();
        }
    }

    public void renderParticles(PoseStack ms, MultiBufferSource buffer, Camera renderInfo, float pt) {
        Minecraft mc = Minecraft.getInstance();
        LightTexture lightTexture = mc.gameRenderer.lightTexture();
        lightTexture.turnOnLightLayer();
        RenderSystem.enableDepthTest();
        Matrix4fStack stack = RenderSystem.getModelViewStack();
        stack.pushMatrix();
        stack.mul((Matrix4fc)ms.last().pose());
        RenderSystem.applyModelViewMatrix();
        for (ParticleRenderType iparticlerendertype : this.byType.keySet()) {
            Iterable iterable;
            if (iparticlerendertype == ParticleRenderType.NO_RENDER || (iterable = (Iterable)this.byType.get(iparticlerendertype)) == null) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::getParticleShader);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder bufferBuilder = iparticlerendertype.begin(tesselator, mc.getTextureManager());
            if (bufferBuilder == null) continue;
            for (Particle particle : iterable) {
                particle.render((VertexConsumer)bufferBuilder, renderInfo, pt);
            }
            MeshData meshData = bufferBuilder.build();
            if (meshData == null) continue;
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        stack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        lightTexture.turnOffLightLayer();
    }

    public void clearEffects() {
        this.byType.clear();
    }
}

