/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.enums;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ConfigBase;
import net.createmod.ponder.config.CClient;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PonderConfig {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    @Nullable
    private static CClient client;

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ModConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll((ModConfigSpec.Builder)builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ModConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static Set<Map.Entry<ModConfig.Type, ConfigBase>> registerConfigs() {
        client = PonderConfig.register(CClient::new, ModConfig.Type.CLIENT);
        return CONFIGS.entrySet();
    }

    public static void onLoad(ModConfig config) {
        for (ConfigBase configBase : CONFIGS.values()) {
            if (configBase.specification != config.getSpec()) continue;
            configBase.onLoad();
        }
    }

    public static void onReload(ModConfig config) {
        for (ConfigBase configBase : CONFIGS.values()) {
            if (configBase.specification != config.getSpec()) continue;
            configBase.onReload();
        }
    }

    public static CClient client() {
        if (client == null) {
            throw new AssertionError((Object)"Ponder Client Config was accessed, but not registered yet!");
        }
        return client;
    }
}

