/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.api.registration;

import java.util.List;
import net.createmod.ponder.api.scene.PonderStoryBoard;
import net.minecraft.resources.ResourceLocation;

public interface StoryBoardEntry {
    public PonderStoryBoard getBoard();

    public String getNamespace();

    public ResourceLocation getSchematicLocation();

    public ResourceLocation getComponent();

    public List<ResourceLocation> getTags();

    public List<SceneOrderingEntry> getOrderingEntries();

    default public StoryBoardEntry orderBefore(String otherSceneId) {
        return this.orderBefore(this.getNamespace(), otherSceneId);
    }

    public StoryBoardEntry orderBefore(String var1, String var2);

    default public StoryBoardEntry orderAfter(String otherSceneId) {
        return this.orderAfter(this.getNamespace(), otherSceneId);
    }

    public StoryBoardEntry orderAfter(String var1, String var2);

    public StoryBoardEntry highlightTag(ResourceLocation var1);

    public StoryBoardEntry highlightTags(ResourceLocation ... var1);

    public StoryBoardEntry highlightAllTags();

    public record SceneOrderingEntry(SceneOrderingType type, ResourceLocation sceneId) {
        public static SceneOrderingEntry after(String namespace, String sceneId) {
            return new SceneOrderingEntry(SceneOrderingType.AFTER, ResourceLocation.fromNamespaceAndPath((String)namespace, (String)sceneId));
        }

        public static SceneOrderingEntry before(String namespace, String sceneId) {
            return new SceneOrderingEntry(SceneOrderingType.BEFORE, ResourceLocation.fromNamespaceAndPath((String)namespace, (String)sceneId));
        }
    }

    public static enum SceneOrderingType {
        BEFORE,
        AFTER;

    }
}

