/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.api.level;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.levelWrappers.WrappedClientLevel;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.createmod.ponder.api.VirtualBlockEntity;
import net.createmod.ponder.api.element.WorldSectionElement;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.PonderWorldParticles;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PonderLevel
extends SchematicLevel {
    @Nullable
    public PonderScene scene;
    protected Map<BlockPos, BlockState> originalBlocks;
    protected Map<BlockPos, CompoundTag> originalBlockEntities;
    protected Map<BlockPos, Integer> blockBreakingProgressions;
    protected List<Entity> originalEntities;
    private final Supplier<ClientLevel> asClientWorld = Suppliers.memoize(() -> WrappedClientLevel.of(this));
    protected PonderWorldParticles particles;
    int overrideLight;
    @Nullable
    Selection mask;
    boolean currentlyTickingEntities;

    public PonderLevel(BlockPos anchor, Level original) {
        super(anchor, original);
        this.originalBlocks = new HashMap<BlockPos, BlockState>();
        this.originalBlockEntities = new HashMap<BlockPos, CompoundTag>();
        this.blockBreakingProgressions = new HashMap<BlockPos, Integer>();
        this.originalEntities = new ArrayList<Entity>();
        this.particles = new PonderWorldParticles(this);
        this.renderMode = true;
    }

    public void createBackup() {
        this.originalBlocks.clear();
        this.originalBlockEntities.clear();
        this.originalBlocks.putAll(this.blocks);
        this.blockEntities.forEach((k, v) -> this.originalBlockEntities.put((BlockPos)k, v.saveWithFullMetadata((HolderLookup.Provider)this.registryAccess())));
        this.entities.forEach(e -> {
            CompoundTag tag = new CompoundTag();
            e.save(tag);
            EntityType.create((CompoundTag)tag, (Level)this).ifPresent(this.originalEntities::add);
        });
    }

    public void restore() {
        this.entities.clear();
        this.blocks.clear();
        this.blockEntities.clear();
        this.blockBreakingProgressions.clear();
        this.renderedBlockEntities.clear();
        this.blocks.putAll(this.originalBlocks);
        this.originalBlockEntities.forEach((k, v) -> {
            BlockEntity blockEntity = BlockEntity.loadStatic((BlockPos)k, (BlockState)this.originalBlocks.get(k), (CompoundTag)v, (HolderLookup.Provider)this.registryAccess());
            this.onBEAdded(blockEntity, blockEntity.getBlockPos());
            this.blockEntities.put(k, blockEntity);
            this.renderedBlockEntities.add(blockEntity);
        });
        this.originalEntities.forEach(e -> {
            CompoundTag tag = new CompoundTag();
            e.save(tag);
            EntityType.create((CompoundTag)tag, (Level)this).ifPresent(this.entities::add);
        });
        this.particles.clearEffects();
        PonderIndex.forEachPlugin(plugin -> plugin.onPonderLevelRestore(this));
    }

    public void restoreBlocks(Selection selection) {
        selection.forEach(p -> {
            BlockEntity blockEntity;
            if (this.originalBlocks.containsKey(p)) {
                this.blocks.put(p, this.originalBlocks.get(p));
            }
            if (this.originalBlockEntities.containsKey(p) && (blockEntity = BlockEntity.loadStatic((BlockPos)p, (BlockState)this.originalBlocks.get(p), (CompoundTag)this.originalBlockEntities.get(p), (HolderLookup.Provider)this.registryAccess())) != null) {
                this.onBEAdded(blockEntity, blockEntity.getBlockPos());
                this.blockEntities.put(p, blockEntity);
            }
        });
        this.redraw();
    }

    private void redraw() {
        if (this.scene != null) {
            this.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
        }
    }

    public void pushFakeLight(int light) {
        this.overrideLight = light;
    }

    public void popLight() {
        this.overrideLight = -1;
    }

    @Override
    public int getBrightness(LightLayer p_226658_1_, BlockPos p_226658_2_) {
        return this.overrideLight == -1 ? 15 : this.overrideLight;
    }

    public void setMask(@Nullable Selection mask) {
        this.mask = mask;
    }

    public void clearMask() {
        this.mask = null;
    }

    @Override
    public BlockState getBlockState(BlockPos globalPos) {
        if (this.mask != null && !this.mask.test(globalPos.subtract((Vec3i)this.anchor))) {
            return Blocks.AIR.defaultBlockState();
        }
        if (this.currentlyTickingEntities && globalPos.getY() < 0) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.getBlockState(globalPos);
    }

    public BlockGetter getChunkForCollisions(int p_225522_1_, int p_225522_2_) {
        return this;
    }

    public void renderEntities(PoseStack ms, SuperRenderTypeBuffer buffer, Camera ari, float pt) {
        Vec3 Vector3d2 = ari.getPosition();
        double d0 = Vector3d2.x();
        double d1 = Vector3d2.y();
        double d2 = Vector3d2.z();
        for (Entity entity : this.entities) {
            if (entity.tickCount == 0) {
                entity.xOld = entity.getX();
                entity.yOld = entity.getY();
                entity.zOld = entity.getZ();
            }
            this.renderEntity(entity, d0, d1, d2, pt, ms, buffer);
        }
        buffer.draw(RenderType.entitySolid((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        buffer.draw(RenderType.entityCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        buffer.draw(RenderType.entityCutoutNoCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        buffer.draw(RenderType.entitySmoothCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
    }

    private void renderEntity(Entity entity, double x, double y, double z, float pt, PoseStack ms, MultiBufferSource buffer) {
        double d0 = Mth.lerp((double)pt, (double)entity.xOld, (double)entity.getX());
        double d1 = Mth.lerp((double)pt, (double)entity.yOld, (double)entity.getY());
        double d2 = Mth.lerp((double)pt, (double)entity.zOld, (double)entity.getZ());
        float f = Mth.lerp((float)pt, (float)entity.yRotO, (float)entity.getYRot());
        EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
        int light = renderManager.getRenderer(entity).getPackedLightCoords(entity, pt);
        renderManager.render(entity, d0 - x, d1 - y, d2 - z, f, pt, ms, buffer, light);
    }

    public void renderParticles(PoseStack ms, MultiBufferSource buffer, Camera ari, float pt) {
        this.particles.renderParticles(ms, buffer, ari, pt);
    }

    public void tick() {
        this.currentlyTickingEntities = true;
        this.particles.tick();
        Iterator iterator = this.entities.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            ++entity.tickCount;
            entity.xOld = entity.getX();
            entity.yOld = entity.getY();
            entity.zOld = entity.getZ();
            entity.tick();
            if (entity.getY() <= -0.5) {
                entity.discard();
            }
            if (entity.isAlive()) continue;
            iterator.remove();
        }
        this.currentlyTickingEntities = false;
    }

    public void addParticle(ParticleOptions data, double x, double y, double z, double mx, double my, double mz) {
        this.addParticle(this.makeParticle(data, x, y, z, mx, my, mz));
    }

    public void addAlwaysVisibleParticle(ParticleOptions data, double x, double y, double z, double mx, double my, double mz) {
        this.addParticle(data, x, y, z, mx, my, mz);
    }

    @Nullable
    private <T extends ParticleOptions> Particle makeParticle(T data, double x, double y, double z, double mx, double my, double mz) {
        return CatnipClientServices.CLIENT_HOOKS.createParticleFromData(data, this.asClientWorld.get(), x, y, z, mx, my, mz);
    }

    @Override
    public boolean setBlock(BlockPos pos, BlockState arg1, int arg2) {
        return super.setBlock(pos, arg1, arg2);
    }

    public void addParticle(@Nullable Particle p) {
        if (p != null) {
            this.particles.addParticle(p);
        }
    }

    protected void onBEAdded(BlockEntity blockEntity, BlockPos pos) {
        super.onBEadded(blockEntity, pos);
        if (!(blockEntity instanceof VirtualBlockEntity)) {
            return;
        }
        VirtualBlockEntity virtualBlockEntity = (VirtualBlockEntity)blockEntity;
        virtualBlockEntity.markVirtual();
    }

    public void setBlockBreakingProgress(BlockPos pos, int damage) {
        if (damage == 0) {
            this.blockBreakingProgressions.remove(pos);
        } else {
            this.blockBreakingProgressions.put(pos, damage - 1);
        }
    }

    public Map<BlockPos, Integer> getBlockBreakingProgressions() {
        return this.blockBreakingProgressions;
    }

    public void addBlockDestroyEffects(BlockPos pos, BlockState state) {
        VoxelShape voxelshape = state.getShape((BlockGetter)this, pos);
        if (voxelshape.isEmpty()) {
            return;
        }
        AABB bb = voxelshape.bounds();
        double d1 = Math.min(1.0, bb.maxX - bb.minX);
        double d2 = Math.min(1.0, bb.maxY - bb.minY);
        double d3 = Math.min(1.0, bb.maxZ - bb.minZ);
        int i = Math.max(2, Mth.ceil((double)(d1 / 0.25)));
        int j = Math.max(2, Mth.ceil((double)(d2 / 0.25)));
        int k = Math.max(2, Mth.ceil((double)(d3 / 0.25)));
        for (int l = 0; l < i; ++l) {
            for (int i1 = 0; i1 < j; ++i1) {
                for (int j1 = 0; j1 < k; ++j1) {
                    double d4 = ((double)l + 0.5) / (double)i;
                    double d5 = ((double)i1 + 0.5) / (double)j;
                    double d6 = ((double)j1 + 0.5) / (double)k;
                    double d7 = d4 * d1 + bb.minX;
                    double d8 = d5 * d2 + bb.minY;
                    double d9 = d6 * d3 + bb.minZ;
                    this.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX() + d7, (double)pos.getY() + d8, (double)pos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                }
            }
        }
    }

    @Override
    protected BlockState processBlockStateForPrinting(BlockState state) {
        return state;
    }

    public boolean hasChunkAt(BlockPos pos) {
        return true;
    }

    public boolean hasChunk(int x, int y) {
        return true;
    }

    public boolean isLoaded(BlockPos pos) {
        return true;
    }

    public boolean hasNearbyAlivePlayer(double p_217358_1_, double p_217358_3_, double p_217358_5_, double p_217358_7_) {
        return true;
    }
}

