/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix4f;

public interface SuperByteBuffer
extends TransformStack<SuperByteBuffer> {
    public static int maxLight(int packedLight1, int packedLight2) {
        int blockLight1 = LightTexture.block((int)packedLight1);
        int skyLight1 = LightTexture.sky((int)packedLight1);
        int blockLight2 = LightTexture.block((int)packedLight2);
        int skyLight2 = LightTexture.sky((int)packedLight2);
        return LightTexture.pack((int)Math.max(blockLight1, blockLight2), (int)Math.max(skyLight1, skyLight2));
    }

    public void renderInto(PoseStack var1, VertexConsumer var2);

    public boolean isEmpty();

    public PoseStack getTransforms();

    public <Self extends SuperByteBuffer> Self reset();

    public <Self extends SuperByteBuffer> Self color(int var1);

    public <Self extends SuperByteBuffer> Self color(int var1, int var2, int var3, int var4);

    public <Self extends SuperByteBuffer> Self disableDiffuse();

    public <Self extends SuperByteBuffer> Self shiftUV(SpriteShiftEntry var1);

    public <Self extends SuperByteBuffer> Self shiftUVScrolling(SpriteShiftEntry var1, float var2, float var3);

    public <Self extends SuperByteBuffer> Self shiftUVtoSheet(SpriteShiftEntry var1, float var2, float var3, int var4);

    public <Self extends SuperByteBuffer> Self overlay(int var1);

    public <Self extends SuperByteBuffer> Self light(int var1);

    public <Self extends SuperByteBuffer> Self useLevelLight(BlockAndTintGetter var1);

    public <Self extends SuperByteBuffer> Self useLevelLight(BlockAndTintGetter var1, Matrix4f var2);

    default public void delete() {
    }

    default public <Self extends SuperByteBuffer> Self rotate(Direction.Axis axis, float radians) {
        return (Self)((SuperByteBuffer)this.rotate(radians, axis));
    }

    default public <Self extends SuperByteBuffer> Self color(Color color) {
        return this.color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    default public <Self extends SuperByteBuffer> Self shiftUVScrolling(SpriteShiftEntry entry, float scrollV) {
        return this.shiftUVScrolling(entry, 0.0f, scrollV);
    }

    public static class ShiftOutput
    implements SpriteShiftFunc.Output {
        public float u;
        public float v;

        @Override
        public void accept(float u, float v) {
            this.u = u;
            this.v = v;
        }
    }

    @FunctionalInterface
    public static interface SpriteShiftFunc {
        public void shift(float var1, float var2, Output var3);

        public static interface Output {
            public void accept(float var1, float var2);
        }
    }
}

