/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import com.mojang.blaze3d.vertex.MeshData;
import java.nio.ByteBuffer;
import net.createmod.catnip.render.TemplateMesh;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class MutableTemplateMesh
extends TemplateMesh {
    public MutableTemplateMesh(int[] data) {
        super(data);
    }

    public MutableTemplateMesh(int vertexCount) {
        super(vertexCount);
    }

    public void copyFrom(int index, TemplateMesh template) {
        System.arraycopy(template.data, 0, this.data, index * 9, template.data.length);
    }

    public MutableTemplateMesh(MeshData data) {
        this(data.drawState().vertexCount());
        int vertexCount = data.drawState().vertexCount();
        ByteBuffer vertexBuffer = data.vertexBuffer();
        int stride = data.drawState().format().getVertexSize();
        MutableTemplateMesh.transferFromVertexData(0, 0, vertexCount, this, vertexBuffer, stride);
    }

    public static void transferFromVertexData(int srcIndex, int dstIndex, int vertexCount, MutableTemplateMesh mutableMesh, ByteBuffer vertexBuffer, int stride) {
        for (int i = 0; i < vertexCount; ++i) {
            mutableMesh.x(dstIndex + i, vertexBuffer.getFloat(srcIndex + i * stride));
            mutableMesh.y(dstIndex + i, vertexBuffer.getFloat(srcIndex + i * stride + 4));
            mutableMesh.z(dstIndex + i, vertexBuffer.getFloat(srcIndex + i * stride + 8));
            mutableMesh.color(dstIndex + i, vertexBuffer.getInt(srcIndex + i * stride + 12));
            mutableMesh.u(dstIndex + i, vertexBuffer.getFloat(srcIndex + i * stride + 16));
            mutableMesh.v(dstIndex + i, vertexBuffer.getFloat(srcIndex + i * stride + 20));
            mutableMesh.overlay(dstIndex + i, OverlayTexture.NO_OVERLAY);
            mutableMesh.light(dstIndex + i, vertexBuffer.getInt(srcIndex + i * stride + 24));
            mutableMesh.normal(dstIndex + i, vertexBuffer.getInt(srcIndex + i * stride + 28));
        }
    }

    public void x(int index, float x) {
        this.data[index * 9 + 0] = Float.floatToRawIntBits(x);
    }

    public void y(int index, float y) {
        this.data[index * 9 + 1] = Float.floatToRawIntBits(y);
    }

    public void z(int index, float z) {
        this.data[index * 9 + 2] = Float.floatToRawIntBits(z);
    }

    public void color(int index, int color) {
        this.data[index * 9 + 3] = color;
    }

    public void u(int index, float u) {
        this.data[index * 9 + 4] = Float.floatToRawIntBits(u);
    }

    public void v(int index, float v) {
        this.data[index * 9 + 5] = Float.floatToRawIntBits(v);
    }

    public void overlay(int index, int overlay) {
        this.data[index * 9 + 6] = overlay;
    }

    public void light(int index, int light) {
        this.data[index * 9 + 7] = light;
    }

    public void normal(int index, int normal) {
        this.data[index * 9 + 8] = normal;
    }

    public TemplateMesh toImmutable() {
        return new TemplateMesh(this.data);
    }
}

