/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.registry;

import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;

public class RegisteredObjectsHelper {
    public static <V> ResourceLocation getKeyOrThrow(Registry<V> registry, V value) {
        ResourceLocation key = registry.getKey(value);
        if (key == null) {
            throw new IllegalArgumentException("Could not get key for value " + String.valueOf(value) + "!");
        }
        return key;
    }

    public static ResourceLocation getKeyOrThrow(Block value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.BLOCK, value);
    }

    public static ResourceLocation getKeyOrThrow(Item value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.ITEM, value);
    }

    public static ResourceLocation getKeyOrThrow(Fluid value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.FLUID, value);
    }

    public static ResourceLocation getKeyOrThrow(EntityType<?> value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.ENTITY_TYPE, value);
    }

    public static ResourceLocation getKeyOrThrow(BlockEntityType<?> value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.BLOCK_ENTITY_TYPE, value);
    }

    public static ResourceLocation getKeyOrThrow(Potion value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.POTION, value);
    }

    public static ResourceLocation getKeyOrThrow(ParticleType<?> value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.PARTICLE_TYPE, value);
    }

    public static ResourceLocation getKeyOrThrow(RecipeSerializer<?> value) {
        return RegisteredObjectsHelper.getKeyOrThrow(BuiltInRegistries.RECIPE_SERIALIZER, value);
    }

    public static Item getItem(ResourceLocation location) {
        return (Item)BuiltInRegistries.ITEM.get(location);
    }

    public static Block getBlock(ResourceLocation location) {
        return (Block)BuiltInRegistries.BLOCK.get(location);
    }

    @Nullable
    public static ItemLike getItemOrBlock(ResourceLocation location) {
        Item item = RegisteredObjectsHelper.getItem(location);
        if (item != Items.AIR) {
            return item;
        }
        Block block = RegisteredObjectsHelper.getBlock(location);
        if (block != Blocks.AIR) {
            return block;
        }
        return null;
    }

    public static ResourceLocation getKeyOrThrow(ItemLike itemLike) {
        if (itemLike instanceof Item) {
            Item item = (Item)itemLike;
            return RegisteredObjectsHelper.getKeyOrThrow(item);
        }
        if (itemLike instanceof Block) {
            Block block = (Block)itemLike;
            return RegisteredObjectsHelper.getKeyOrThrow(block);
        }
        throw new IllegalArgumentException("Could not get key for itemLike " + String.valueOf(itemLike) + "!");
    }
}

