/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.platform;

import net.createmod.catnip.net.base.CatnipPacketRegistry;
import net.createmod.catnip.net.base.ClientboundPacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.createmod.catnip.platform.services.NetworkHelper;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.ApiStatus;

public class NeoForgeNetworkHelper
implements NetworkHelper {
    @Override
    @ApiStatus.Internal
    public void registerPackets(CatnipPacketRegistry packetRegistry) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(packetRegistry.modId).orElseThrow();
        container.getEventBus().addListener(e -> {
            PayloadRegistrar registrar = e.registrar(packetRegistry.networkVersion);
            for (CatnipPacketRegistry.PacketType<?> type : packetRegistry.packetsView) {
                CatnipPacketRegistry.PacketType<?> casted;
                boolean clientbound = ClientboundPacketPayload.class.isAssignableFrom(type.clazz());
                boolean serverbound = ServerboundPacketPayload.class.isAssignableFrom(type.clazz());
                if (clientbound && serverbound) {
                    throw new IllegalStateException("Packet class is both clientbound and serverbound: " + String.valueOf(type.clazz()));
                }
                if (clientbound) {
                    casted = type;
                    registrar.playToClient(casted.type(), casted.codec(), (payload, ctx) -> ctx.enqueueWork(() -> payload.handleInternal(ctx.player())));
                    continue;
                }
                if (!serverbound) continue;
                casted = type;
                registrar.playToServer(casted.type(), casted.codec(), (payload, ctx) -> ctx.enqueueWork(() -> payload.handle((ServerPlayer)ctx.player())));
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToClient(ServerPlayer player, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToAllClients(CustomPacketPayload payload) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToClientsTrackingAndSelf(Entity entity, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToClientsTrackingEntity(Entity entity, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToClientsTrackingChunk(ServerLevel serverLevel, ChunkPos chunk, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)chunk, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToClientsAround(ServerLevel serverLevel, Vec3 pos, double radius, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)pos.x(), (double)pos.y(), (double)pos.z(), (double)radius, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

