/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.placement;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class PlacementOffset {
    private final boolean success;
    private Vec3i pos;
    private Function<BlockState, BlockState> stateTransform;
    @Nullable
    private BlockState ghostState;

    private PlacementOffset(boolean success) {
        this.success = success;
        this.pos = BlockPos.ZERO;
        this.stateTransform = Function.identity();
        this.ghostState = null;
    }

    public static PlacementOffset fail() {
        return new PlacementOffset(false);
    }

    public static PlacementOffset success() {
        return new PlacementOffset(true);
    }

    public static PlacementOffset success(Vec3i pos) {
        return PlacementOffset.success().at(pos);
    }

    public static PlacementOffset success(Vec3i pos, Function<BlockState, BlockState> transform) {
        return PlacementOffset.success().at(pos).withTransform(transform);
    }

    public PlacementOffset at(Vec3i pos) {
        this.pos = pos;
        return this;
    }

    public PlacementOffset withTransform(Function<BlockState, BlockState> stateTransform) {
        this.stateTransform = stateTransform;
        return this;
    }

    public PlacementOffset withGhostState(BlockState ghostState) {
        this.ghostState = ghostState;
        return this;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public Vec3i getPos() {
        return this.pos;
    }

    public BlockPos getBlockPos() {
        if (this.pos instanceof BlockPos) {
            return (BlockPos)this.pos;
        }
        return new BlockPos(this.pos);
    }

    public Function<BlockState, BlockState> getTransform() {
        return this.stateTransform;
    }

    public boolean hasGhostState() {
        return this.ghostState != null;
    }

    @Nullable
    public BlockState getGhostState() {
        return this.ghostState;
    }

    public boolean isReplaceable(Level world) {
        if (!this.success) {
            return false;
        }
        return world.getBlockState(new BlockPos(this.pos)).canBeReplaced();
    }

    public ItemInteractionResult placeInWorld(Level world, BlockItem blockItem, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!this.isReplaceable(world)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        UseOnContext context = new UseOnContext(player, hand, ray);
        BlockPos newPos = new BlockPos(this.pos);
        ItemStack stackBefore = player.getItemInHand(hand).copy();
        if (!world.mayInteract(player, newPos)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockState state = this.stateTransform.apply(blockItem.getBlock().defaultBlockState());
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            FluidState fluidState = world.getFluidState(newPos);
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        if (CatnipServices.HOOKS.playerPlaceSingleBlock(player, world, newPos, state)) {
            return ItemInteractionResult.FAIL;
        }
        BlockState newState = world.getBlockState(newPos);
        SoundType soundtype = newState.getSoundType();
        world.playSound(null, newPos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        world.gameEvent((Holder)GameEvent.BLOCK_PLACE, newPos, GameEvent.Context.of((Entity)player, (BlockState)newState));
        player.awardStat(Stats.ITEM_USED.get((Object)blockItem));
        newState.getBlock().setPlacedBy(world, newPos, newState, (LivingEntity)player, stackBefore);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, newPos, context.getItemInHand());
        }
        if (!player.isCreative()) {
            context.getItemInHand().shrink(1);
        }
        return ItemInteractionResult.SUCCESS;
    }
}

