/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.placement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.ghostblock.GhostBlocks;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public interface IPlacementHelper {
    public static final BlockState ID = new BlockState(Blocks.AIR, null, null);

    public Predicate<ItemStack> getItemPredicate();

    public Predicate<BlockState> getStatePredicate();

    public PlacementOffset getOffset(Player var1, Level var2, BlockState var3, BlockPos var4, BlockHitResult var5);

    default public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray, ItemStack heldItem) {
        PlacementOffset offset = this.getOffset(player, world, state, pos, ray);
        Item item = heldItem.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            offset = offset.withGhostState(blockItem.getBlock().defaultBlockState());
        }
        return offset;
    }

    default public void renderAt(BlockPos pos, BlockState state, BlockHitResult ray, PlacementOffset offset) {
        this.displayGhost(offset);
    }

    public static void renderArrow(Vec3 center, Vec3 target, Direction arrowPlane) {
        IPlacementHelper.renderArrow(center, target, arrowPlane, 1.0);
    }

    public static void renderArrow(Vec3 center, Vec3 target, Direction arrowPlane, double distanceFromCenter) {
        Vec3 direction = target.subtract(center).normalize();
        Vec3 facing = Vec3.atLowerCornerOf((Vec3i)arrowPlane.getNormal());
        Vec3 start = center.add(direction);
        Vec3 offset = direction.scale(distanceFromCenter - 1.0);
        Vec3 offsetA = direction.cross(facing).normalize().scale(0.25);
        Vec3 offsetB = facing.cross(direction).normalize().scale(0.25);
        Vec3 endA = center.add(direction.scale(0.75)).add(offsetA);
        Vec3 endB = center.add(direction.scale(0.75)).add(offsetB);
        Outliner.getInstance().showLine("placementArrowA" + String.valueOf(center) + String.valueOf(target), start.add(offset), endA.add(offset)).lineWidth(0.0625f);
        Outliner.getInstance().showLine("placementArrowB" + String.valueOf(center) + String.valueOf(target), start.add(offset), endB.add(offset)).lineWidth(0.0625f);
    }

    default public void displayGhost(PlacementOffset offset) {
        if (!offset.hasGhostState()) {
            return;
        }
        GhostBlocks.getInstance().showGhostState(this, offset.getTransform().apply(offset.getGhostState())).at(offset.getBlockPos()).breathingAlpha();
    }

    public static List<Direction> orderedByDistanceOnlyAxis(BlockPos pos, Vec3 hit, Direction.Axis axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, (Direction dir) -> dir.getAxis() == axis);
    }

    public static List<Direction> orderedByDistanceOnlyAxis(BlockPos pos, Vec3 hit, Direction.Axis axis, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<Direction>)dir -> dir.getAxis() == axis).and(includeDirection));
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vec3 hit, Direction.Axis axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, (Direction dir) -> dir.getAxis() != axis);
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vec3 hit, Direction.Axis axis, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<Direction>)dir -> dir.getAxis() != axis).and(includeDirection));
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vec3 hit, Direction.Axis first, Direction.Axis second) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, (Direction d) -> d.getAxis() != second);
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vec3 hit, Direction.Axis first, Direction.Axis second, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, ((Predicate<Direction>)d -> d.getAxis() != second).and(includeDirection));
    }

    public static List<Direction> orderedByDistance(BlockPos pos, Vec3 hit) {
        return IPlacementHelper.orderedByDistance(pos, hit, (Direction _$) -> true);
    }

    public static List<Direction> orderedByDistance(BlockPos pos, Vec3 hit, Predicate<Direction> includeDirection) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Direction dir : Iterate.directions) {
            if (!includeDirection.test(dir)) continue;
            directions.add(dir);
        }
        return IPlacementHelper.orderedByDistance(pos, hit, directions);
    }

    public static List<Direction> orderedByDistance(BlockPos pos, Vec3 hit, Collection<Direction> directions) {
        Vec3 centerToHit = hit.subtract(VecHelper.getCenterOf((Vec3i)pos));
        ArrayList<Pair> distances = new ArrayList<Pair>();
        for (Direction dir : directions) {
            distances.add(Pair.of(dir, Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).distanceTo(centerToHit)));
        }
        distances.sort(Comparator.comparingDouble(Pair::getSecond));
        ArrayList<Direction> sortedDirections = new ArrayList<Direction>();
        for (Pair p : distances) {
            sortedDirections.add((Direction)p.getFirst());
        }
        return sortedDirections;
    }

    default public boolean matchesItem(ItemStack item) {
        return this.getItemPredicate().test(item);
    }

    default public boolean matchesState(BlockState state) {
        return this.getStatePredicate().test(state);
    }
}

