/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.outliner;

import com.mojang.blaze3d.vertex.PoseStack;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4f;

public class ChasingAABBOutline
extends AABBOutline {
    AABB targetBB;
    AABB prevBB;

    public ChasingAABBOutline(AABB bb) {
        super(bb);
        this.prevBB = bb.inflate(0.0);
        this.targetBB = bb.inflate(0.0);
    }

    public void target(AABB target) {
        this.targetBB = target;
    }

    @Override
    public void tick() {
        this.prevBB = this.bb;
        this.setBounds(ChasingAABBOutline.interpolateBBs(this.bb, this.targetBB, 0.5f));
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, float pt) {
        this.params.loadColor(this.colorTemp);
        Vector4f color = this.colorTemp;
        int lightmap = this.params.lightmap;
        boolean disableLineNormals = this.params.disableLineNormals;
        this.renderBox(ms, buffer, camera, ChasingAABBOutline.interpolateBBs(this.prevBB, this.bb, pt), color, lightmap, disableLineNormals);
    }

    private static AABB interpolateBBs(AABB current, AABB target, float pt) {
        return new AABB(Mth.lerp((double)pt, (double)current.minX, (double)target.minX), Mth.lerp((double)pt, (double)current.minY, (double)target.minY), Mth.lerp((double)pt, (double)current.minZ, (double)target.minZ), Mth.lerp((double)pt, (double)current.maxX, (double)target.maxX), Mth.lerp((double)pt, (double)current.maxY, (double)target.maxY), Mth.lerp((double)pt, (double)current.maxZ, (double)target.maxZ));
    }
}

