/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.net.packets;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.net.CatnipPackets;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.createmod.ponder.Ponder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerboundConfigPacket<T>
implements ServerboundPacketPayload {
    public static final StreamCodec<ByteBuf, ServerboundConfigPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, p -> p.modID, (StreamCodec)ByteBufCodecs.STRING_UTF8, p -> p.path, (StreamCodec)ByteBufCodecs.STRING_UTF8, p -> p.value, ServerboundConfigPacket::new);
    private final String modID;
    private final String path;
    private final String value;

    public ServerboundConfigPacket(String modID, String path, T value) {
        this.modID = Objects.requireNonNull(modID);
        this.path = path;
        this.value = this.serialize(value);
    }

    public ServerboundConfigPacket(String modID, String path, String serialized) {
        this.modID = Objects.requireNonNull(modID);
        this.path = path;
        this.value = serialized;
    }

    @Override
    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return CatnipPackets.SERVERBOUND_CONFIG;
    }

    @Override
    public void handle(ServerPlayer player) {
        try {
            ModConfigSpec.ConfigValue configValue;
            Object v;
            if (!player.hasPermissions(2)) {
                return;
            }
            ModConfigSpec spec = ConfigHelper.findModConfigSpecFor(ModConfig.Type.SERVER, this.modID);
            ModConfigSpec.ValueSpec valueSpec = (ModConfigSpec.ValueSpec)spec.getSpec().getRaw(this.path);
            if (!valueSpec.test(v = ServerboundConfigPacket.deserialize((configValue = (ModConfigSpec.ConfigValue)spec.getValues().get(this.path)).get(), this.value))) {
                return;
            }
            configValue.set(v);
            configValue.save();
        }
        catch (Exception e) {
            Ponder.LOGGER.warn("Unable to handle ConfigureConfig Packet. ", (Throwable)e);
        }
    }

    public String serialize(T value) {
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        throw new IllegalArgumentException("unknown type " + String.valueOf(value) + ": " + value.getClass().getSimpleName());
    }

    public static Object deserialize(Object type, String sValue) {
        if (type instanceof Boolean) {
            return Boolean.parseBoolean(sValue);
        }
        if (type instanceof Enum) {
            return Enum.valueOf(((Enum)type).getClass(), sValue);
        }
        if (type instanceof Integer) {
            return Integer.parseInt(sValue);
        }
        if (type instanceof Float) {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        if (type instanceof Double) {
            return Double.parseDouble(sValue);
        }
        throw new IllegalArgumentException("unknown type " + String.valueOf(type) + ": " + type.getClass().getSimpleName());
    }
}

