/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.nbt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.createmod.catnip.components.ComponentProcessors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class NBTProcessors {
    private static final Map<BlockEntityType<?>, UnaryOperator<CompoundTag>> processors = new HashMap();
    private static final Map<BlockEntityType<?>, UnaryOperator<CompoundTag>> survivalProcessors = new HashMap();
    private static final UnaryOperator<CompoundTag> signProcessor = data -> {
        for (String key : List.of("front_text", "back_text")) {
            CompoundTag textTag = data.getCompound(key);
            if (!textTag.contains("messages", 9)) continue;
            for (Tag tag : textTag.getList("messages", 8)) {
                StringTag stringTag;
                if (!(tag instanceof StringTag) || !NBTProcessors.textComponentHasClickEvent((stringTag = (StringTag)tag).getAsString())) continue;
                return null;
            }
        }
        if (data.contains("front_item") || data.contains("back_item")) {
            return null;
        }
        return data;
    };

    public static synchronized void addProcessor(BlockEntityType<?> type, UnaryOperator<CompoundTag> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(BlockEntityType<?> type, UnaryOperator<CompoundTag> processor) {
        survivalProcessors.put(type, processor);
    }

    public static UnaryOperator<CompoundTag> itemProcessor(String tagKey) {
        return data -> {
            CompoundTag compound = data.getCompound(tagKey);
            if (!compound.contains("components", 10)) {
                return data;
            }
            CompoundTag itemComponents = compound.getCompound("components");
            HashSet keys = new HashSet(itemComponents.getAllKeys());
            for (String key : keys) {
                DataComponentType type = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.parse((String)key));
                if (type == null || !ComponentProcessors.isUnsafeItemComponent(type)) continue;
                itemComponents.remove(key);
            }
            if (itemComponents.isEmpty()) {
                compound.remove("components");
            }
            return data;
        };
    }

    public static boolean textComponentHasClickEvent(String json) {
        return NBTProcessors.textComponentHasClickEvent((Component)Component.Serializer.fromJson((String)(json.isEmpty() ? "\"\"" : json), (HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    public static boolean textComponentHasClickEvent(Component component) {
        for (Component sibling : component.getSiblings()) {
            if (!NBTProcessors.textComponentHasClickEvent(sibling)) continue;
            return true;
        }
        return component != null && component.getStyle() != null && component.getStyle().getClickEvent() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static CompoundTag process(BlockState state, BlockEntity blockEntity, @Nullable CompoundTag compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        BlockEntityType type = blockEntity.getType();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (CompoundTag)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (CompoundTag)processors.get(type).apply(compound);
        }
        if (blockEntity instanceof SpawnerBlockEntity) {
            return compound;
        }
        if (state.is(BlockTags.ALL_SIGNS)) {
            return (CompoundTag)signProcessor.apply(compound);
        }
        if (blockEntity.onlyOpCanSetNbt()) {
            return null;
        }
        return compound;
    }
}

