/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.math;

import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.createmod.ponder.mixin.client.accessor.GameRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VecHelper {
    public static final Vec3 CENTER_OF_ORIGIN = new Vec3(0.5, 0.5, 0.5);

    public static Vec3 rotate(Vec3 vec, Vec3 rotationVec) {
        return VecHelper.rotate(vec, rotationVec.x, rotationVec.y, rotationVec.z);
    }

    public static Vec3 rotate(Vec3 vec, double xRot, double yRot, double zRot) {
        return VecHelper.rotate(VecHelper.rotate(VecHelper.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vec3 rotateCentered(Vec3 vec, double deg, Direction.Axis axis) {
        Vec3 shift = VecHelper.getCenterOf((Vec3i)BlockPos.ZERO);
        return VecHelper.rotate(vec.subtract(shift), deg, axis).add(shift);
    }

    public static Vec3 rotate(Vec3 vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3.ZERO) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Mth.sin((float)angle);
        double cos = Mth.cos((float)angle);
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        if (axis == Direction.Axis.X) {
            return new Vec3(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static Vec3 mirrorCentered(Vec3 vec, Mirror mirror) {
        Vec3 shift = VecHelper.getCenterOf((Vec3i)BlockPos.ZERO);
        return VecHelper.mirror(vec.subtract(shift), mirror).add(shift);
    }

    public static Vec3 mirror(Vec3 vec, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return vec;
        }
        if (vec == Vec3.ZERO) {
            return vec;
        }
        double x = vec.x;
        double y = vec.y;
        double z = vec.z;
        if (mirror == Mirror.LEFT_RIGHT) {
            return new Vec3(x, y, -z);
        }
        if (mirror == Mirror.FRONT_BACK) {
            return new Vec3(-x, y, z);
        }
        return vec;
    }

    public static Vec3 lookAt(Vec3 vec, Vec3 fwd) {
        Vec3 up;
        double dot = (fwd = fwd.normalize()).dot(up = new Vec3(0.0, 1.0, 0.0));
        if (Math.abs(dot) > 0.999) {
            up = new Vec3(0.0, 0.0, dot > 0.0 ? 1.0 : -1.0);
        }
        Vec3 right = fwd.cross(up).normalize();
        up = right.cross(fwd).normalize();
        double x = vec.x * right.x + vec.y * up.x + vec.z * fwd.x;
        double y = vec.x * right.y + vec.y * up.y + vec.z * fwd.y;
        double z = vec.x * right.z + vec.y * up.z + vec.z * fwd.z;
        return new Vec3(x, y, z);
    }

    public static boolean isVecPointingTowards(Vec3 vec, Direction direction) {
        return Vec3.atLowerCornerOf((Vec3i)direction.getNormal()).dot(vec.normalize()) > 0.125;
    }

    public static Vec3 getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.ZERO)) {
            return CENTER_OF_ORIGIN;
        }
        return Vec3.atLowerCornerOf((Vec3i)pos).add(0.5, 0.5, 0.5);
    }

    public static Vec3 offsetRandomly(Vec3 vec, RandomSource r, float radius) {
        return new Vec3(vec.x + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.y + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.z + (double)((r.nextFloat() - 0.5f) * 2.0f * radius));
    }

    public static Vec3 axisAlingedPlaneOf(Vec3 vec) {
        vec = vec.normalize();
        return new Vec3(1.0, 1.0, 1.0).subtract(Math.abs(vec.x), Math.abs(vec.y), Math.abs(vec.z));
    }

    public static Vec3 axisAlingedPlaneOf(Direction face) {
        return VecHelper.axisAlingedPlaneOf(Vec3.atLowerCornerOf((Vec3i)face.getNormal()));
    }

    public static ListTag writeNBT(Vec3 vec) {
        ListTag listnbt = new ListTag();
        listnbt.add((Object)DoubleTag.valueOf((double)vec.x));
        listnbt.add((Object)DoubleTag.valueOf((double)vec.y));
        listnbt.add((Object)DoubleTag.valueOf((double)vec.z));
        return listnbt;
    }

    public static CompoundTag writeNBTCompound(Vec3 vec) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("V", (Tag)VecHelper.writeNBT(vec));
        return compoundTag;
    }

    public static Vec3 readNBT(ListTag list) {
        if (list.isEmpty()) {
            return Vec3.ZERO;
        }
        return new Vec3(list.getDouble(0), list.getDouble(1), list.getDouble(2));
    }

    public static Vec3 readNBTCompound(CompoundTag nbt) {
        return VecHelper.readNBT(nbt.getList("V", 6));
    }

    public static void write(Vec3 vec, FriendlyByteBuf buffer) {
        buffer.writeDouble(vec.x);
        buffer.writeDouble(vec.y);
        buffer.writeDouble(vec.z);
    }

    public static Vec3 read(FriendlyByteBuf buffer) {
        return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static Vec3 voxelSpace(double x, double y, double z) {
        return new Vec3(x, y, z).scale(0.0625);
    }

    public static int getCoordinate(Vec3i pos, Direction.Axis axis) {
        return axis.choose(pos.getX(), pos.getY(), pos.getZ());
    }

    public static float getCoordinate(Vec3 vec, Direction.Axis axis) {
        return (float)axis.choose(vec.x, vec.y, vec.z);
    }

    public static boolean onSameAxis(BlockPos pos1, BlockPos pos2, Direction.Axis axis) {
        if (pos1.equals((Object)pos2)) {
            return true;
        }
        for (Direction.Axis otherAxis : Direction.Axis.values()) {
            if (axis == otherAxis || VecHelper.getCoordinate((Vec3i)pos1, otherAxis) == VecHelper.getCoordinate((Vec3i)pos2, otherAxis)) continue;
            return false;
        }
        return true;
    }

    public static Vec3 clamp(Vec3 vec, float maxLength) {
        return vec.lengthSqr() > (double)(maxLength * maxLength) ? vec.normalize().scale((double)maxLength) : vec;
    }

    public static Vec3 lerp(float p, Vec3 from, Vec3 to) {
        return from.add(to.subtract(from).scale((double)p));
    }

    public static Vec3 slerp(float p, Vec3 from, Vec3 to) {
        double theta = Math.acos(from.dot(to));
        return from.scale((double)Mth.sin((float)(1.0f - p)) * theta).add(to.scale((double)Mth.sin((float)((float)(theta * (double)p))))).scale((double)(1.0f / Mth.sin((float)((float)theta))));
    }

    public static Vec3 clampComponentWise(Vec3 vec, float maxLength) {
        return new Vec3(Mth.clamp((double)vec.x, (double)(-maxLength), (double)maxLength), Mth.clamp((double)vec.y, (double)(-maxLength), (double)maxLength), Mth.clamp((double)vec.z, (double)(-maxLength), (double)maxLength));
    }

    public static Vec3 componentMin(Vec3 vec1, Vec3 vec2) {
        return new Vec3(Math.min(vec1.x, vec2.x), Math.min(vec1.y, vec2.y), Math.min(vec1.z, vec2.z));
    }

    public static Vec3 componentMax(Vec3 vec1, Vec3 vec2) {
        return new Vec3(Math.max(vec1.x, vec2.x), Math.max(vec1.y, vec2.y), Math.max(vec1.z, vec2.z));
    }

    public static Vec3 project(Vec3 vec, Vec3 ontoVec) {
        if (ontoVec.equals((Object)Vec3.ZERO)) {
            return Vec3.ZERO;
        }
        return ontoVec.scale(vec.dot(ontoVec) / ontoVec.lengthSqr());
    }

    @Nullable
    public static Vec3 intersectSphere(Vec3 origin, Vec3 lineDirection, Vec3 sphereCenter, double radius) {
        Vec3 diff;
        double lineDotDiff;
        double delta;
        if (lineDirection.equals((Object)Vec3.ZERO)) {
            return null;
        }
        if (lineDirection.lengthSqr() != 1.0) {
            lineDirection = lineDirection.normalize();
        }
        if ((delta = (lineDotDiff = lineDirection.dot(diff = origin.subtract(sphereCenter))) * lineDotDiff - (diff.lengthSqr() - radius * radius)) < 0.0) {
            return null;
        }
        double t = -lineDotDiff + Math.sqrt(delta);
        return origin.add(lineDirection.scale(t));
    }

    public static Vec3 projectToPlayerView(Vec3 target, float partialTicks) {
        Entity renderViewEntity;
        Camera ari = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 camera_pos = ari.getPosition();
        Quaternionf camera_rotation_conj = new Quaternionf((Quaternionfc)ari.rotation());
        camera_rotation_conj.conjugate();
        Vector3f result3f = new Vector3f((float)(camera_pos.x - target.x), (float)(camera_pos.y - target.y), (float)(camera_pos.z - target.z));
        result3f.rotate((Quaternionfc)camera_rotation_conj);
        Minecraft mc = Minecraft.getInstance();
        if (((Boolean)mc.options.bobView().get()).booleanValue() && (renderViewEntity = mc.getCameraEntity()) instanceof Player) {
            Player playerEntity = (Player)renderViewEntity;
            float walkDist_modified = playerEntity.walkDist;
            float f = walkDist_modified - playerEntity.walkDistO;
            float f1 = -(walkDist_modified + f * partialTicks);
            float f2 = Mth.lerp((float)partialTicks, (float)playerEntity.oBob, (float)playerEntity.bob);
            Quaternionf q2 = Axis.XP.rotationDegrees(Math.abs(Mth.cos((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f);
            q2.conjugate();
            result3f.rotate((Quaternionfc)q2);
            Quaternionf q1 = Axis.ZP.rotationDegrees(Mth.sin((float)(f1 * (float)Math.PI)) * f2 * 3.0f);
            q1.conjugate();
            result3f.rotate((Quaternionfc)q1);
            Vector3f bob_translation = new Vector3f(Mth.sin((float)(f1 * (float)Math.PI)) * f2 * 0.5f, -Math.abs(Mth.cos((float)(f1 * (float)Math.PI)) * f2), 0.0f);
            bob_translation.set(bob_translation.x(), -bob_translation.y(), bob_translation.z());
            result3f.add((Vector3fc)bob_translation);
        }
        float fov = (float)((GameRendererAccessor)mc.gameRenderer).catnip$callGetFov(ari, partialTicks, true);
        float half_height = (float)mc.getWindow().getGuiScaledHeight() / 2.0f;
        float scale_factor = half_height / (result3f.z() * (float)Math.tan(Math.toRadians(fov / 2.0f)));
        return new Vec3((double)(-result3f.x() * scale_factor), (double)(result3f.y() * scale_factor), (double)result3f.z());
    }

    public static Vec3 bezier(Vec3 p1, Vec3 p2, Vec3 q1, Vec3 q2, float t) {
        Vec3 v1 = VecHelper.lerp(t, p1, q1);
        Vec3 v2 = VecHelper.lerp(t, q1, q2);
        Vec3 v3 = VecHelper.lerp(t, q2, p2);
        Vec3 inner1 = VecHelper.lerp(t, v1, v2);
        Vec3 inner2 = VecHelper.lerp(t, v2, v3);
        return VecHelper.lerp(t, inner1, inner2);
    }

    public static Vec3 bezierDerivative(Vec3 p1, Vec3 p2, Vec3 q1, Vec3 q2, float t) {
        return p1.scale((double)(-3.0f * t * t + 6.0f * t - 3.0f)).add(q1.scale((double)(9.0f * t * t - 12.0f * t + 3.0f))).add(q2.scale((double)(-9.0f * t * t + 6.0f * t))).add(p2.scale((double)(3.0f * t * t)));
    }

    @Nullable
    public static double[] intersectRanged(Vec3 p1, Vec3 q1, Vec3 p2, Vec3 q2, Direction.Axis plane) {
        Vec3 pDiff = p2.subtract(p1);
        Vec3 qDiff = q2.subtract(q1);
        double[] intersect = VecHelper.intersect(p1, q1, pDiff.normalize(), qDiff.normalize(), plane);
        if (intersect == null) {
            return null;
        }
        if (intersect[0] < 0.0 || intersect[1] < 0.0) {
            return null;
        }
        if (intersect[0] * intersect[0] > pDiff.lengthSqr() || intersect[1] * intersect[1] > qDiff.lengthSqr()) {
            return null;
        }
        return intersect;
    }

    @Nullable
    public static double[] intersect(Vec3 p1, Vec3 p2, Vec3 r, Vec3 s, Direction.Axis plane) {
        if (plane == Direction.Axis.X) {
            p1 = new Vec3(p1.y, 0.0, p1.z);
            p2 = new Vec3(p2.y, 0.0, p2.z);
            r = new Vec3(r.y, 0.0, r.z);
            s = new Vec3(s.y, 0.0, s.z);
        }
        if (plane == Direction.Axis.Z) {
            p1 = new Vec3(p1.x, 0.0, p1.y);
            p2 = new Vec3(p2.x, 0.0, p2.y);
            r = new Vec3(r.x, 0.0, r.y);
            s = new Vec3(s.x, 0.0, s.y);
        }
        Vec3 qminusp = p2.subtract(p1);
        double rcs = r.x * s.z - r.z * s.x;
        if (Mth.equal((double)rcs, (double)0.0)) {
            return null;
        }
        Vec3 rdivrcs = r.scale(1.0 / rcs);
        Vec3 sdivrcs = s.scale(1.0 / rcs);
        double t = qminusp.x * sdivrcs.z - qminusp.z * sdivrcs.x;
        double u = qminusp.x * rdivrcs.z - qminusp.z * rdivrcs.x;
        return new double[]{t, u};
    }

    public static double alignedDistanceToFace(Vec3 pos, BlockPos blockPos, Direction face) {
        Direction.Axis axis = face.getAxis();
        return Math.abs(VecHelper.getCoordinate(pos, axis) - (float)(blockPos.get(axis) + (face.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1 : 0)));
    }
}

