/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.codec.StreamCodec;

public class BlockFace
extends Pair<BlockPos, Direction> {
    public static Codec<BlockFace> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(BlockFace::getPos), (App)Direction.CODEC.fieldOf("direction").forGetter(BlockFace::getFace)).apply((Applicative)instance, BlockFace::new));
    public static StreamCodec<ByteBuf, BlockFace> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BlockFace::getPos, (StreamCodec)Direction.STREAM_CODEC, BlockFace::getFace, BlockFace::new);

    public BlockFace(BlockPos first, Direction second) {
        super(first, second);
    }

    public boolean isEquivalent(BlockFace other) {
        if (this.equals(other)) {
            return true;
        }
        return this.getConnectedPos().equals((Object)other.getPos()) && this.getPos().equals((Object)other.getConnectedPos());
    }

    public BlockPos getPos() {
        return (BlockPos)this.getFirst();
    }

    public Direction getFace() {
        return (Direction)this.getSecond();
    }

    public Direction getOppositeFace() {
        return ((Direction)this.getSecond()).getOpposite();
    }

    public BlockFace getOpposite() {
        return new BlockFace(this.getConnectedPos(), this.getOppositeFace());
    }

    public BlockPos getConnectedPos() {
        return this.getPos().relative(this.getFace());
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("Pos", NbtUtils.writeBlockPos((BlockPos)this.getPos()));
        NBTHelper.writeEnum(compoundNBT, "Face", this.getFace());
        return compoundNBT;
    }

    public static BlockFace fromNBT(CompoundTag compound) {
        return new BlockFace(NBTHelper.readBlockPos(compound, "Pos"), NBTHelper.readEnum(compound, "Face", Direction.class));
    }
}

