/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.lang;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.BreakIterator;
import java.util.LinkedList;
import java.util.List;
import net.createmod.catnip.platform.CatnipClientServices;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public class ClientFontHelper {
    public static List<String> cutString(Font font, String text, int maxWidthPerLine) {
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(CatnipClientServices.CLIENT_HOOKS.getCurrentLocale());
        iterator.setText(text);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = text.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.width(word);
            if (width + newWidth > maxWidthPerLine) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static void drawSplitString(GuiGraphics graphics, PoseStack ms, Font font, String text, int x, int y, int width, int color) {
        List<String> list = ClientFontHelper.cutString(font, text, width);
        Matrix4f matrix4f = ms.last().pose();
        for (String s : list) {
            float f = x;
            if (font.isBidirectional()) {
                int i = font.width(font.bidirectionalShaping(s));
                f += (float)(width - i);
            }
            ClientFontHelper.draw(graphics, font, s, f, y, color, matrix4f, false);
            y += 9;
        }
    }

    private static int draw(GuiGraphics graphics, Font font, String p_228078_1_, float p_228078_2_, float p_228078_3_, int p_228078_4_, Matrix4f p_228078_5_, boolean p_228078_6_) {
        if (p_228078_1_ == null) {
            return 0;
        }
        MultiBufferSource.BufferSource irendertypebuffer$impl = graphics.bufferSource();
        int i = font.drawInBatch(p_228078_1_, p_228078_2_, p_228078_3_, p_228078_4_, p_228078_6_, p_228078_5_, (MultiBufferSource)irendertypebuffer$impl, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        irendertypebuffer$impl.endBatch();
        return i;
    }
}

