/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TextStencilElement
extends DelegatedStencilElement {
    protected Font font;
    protected MutableComponent component = Component.empty();
    protected boolean centerVertically = false;
    protected boolean centerHorizontally = false;

    public TextStencilElement(Font font) {
        this.font = font;
        this.height = 10;
    }

    public TextStencilElement(Font font, String text) {
        this(font);
        this.component = Component.literal((String)text);
    }

    public TextStencilElement(Font font, MutableComponent component) {
        this(font);
        this.component = component;
    }

    public TextStencilElement withText(String text) {
        this.component = Component.literal((String)text);
        return this;
    }

    public TextStencilElement withText(MutableComponent component) {
        this.component = component;
        return this;
    }

    public TextStencilElement centered(boolean vertical, boolean horizontal) {
        this.centerVertically = vertical;
        this.centerHorizontally = horizontal;
        return this;
    }

    @Override
    public void renderStencil(GuiGraphics graphics) {
        float x = 0.0f;
        float y = 0.0f;
        if (this.centerHorizontally) {
            x = (float)this.width / 2.0f - (float)this.font.width((FormattedText)this.component) / 2.0f;
        }
        if (this.centerVertically) {
            float f = (float)this.height / 2.0f;
            Objects.requireNonNull(this.font);
            y = f - (float)(9 - 1) / 2.0f;
        }
        graphics.drawString(this.font, (Component)this.component, Math.round(x), Math.round(y), Color.BLACK.getRGB(), false);
        graphics.flush();
    }

    @Override
    public void renderElement(GuiGraphics graphics) {
        float x = 0.0f;
        float y = 0.0f;
        if (this.centerHorizontally) {
            x = (float)this.width / 2.0f - (float)this.font.width((FormattedText)this.component) / 2.0f;
        }
        if (this.centerVertically) {
            float f = (float)this.height / 2.0f;
            Objects.requireNonNull(this.font);
            y = f - (float)(9 - 1) / 2.0f;
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(x, y, 0.0f);
        int n = this.font.width((FormattedText)this.component);
        Objects.requireNonNull(this.font);
        this.element.render(graphics, n, 9 + 2, this.alpha);
        poseStack.popPose();
    }

    public MutableComponent getComponent() {
        return this.component;
    }
}

