/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.TextureSheetSegment;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class UIRenderHelper {
    public static final Couple<Color> COLOR_TEXT = Couple.create(new Color(-1118482), new Color(-6052957)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_DARKER = Couple.create(new Color(-6052957), new Color(-8355712)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_ACCENT = Couple.create(new Color(-2232577), new Color(-6246208)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_TEXT_STRONG_ACCENT = Couple.create(new Color(-7686442), new Color(-9530709)).map(Color::setImmutable);
    public static final Color COLOR_STREAK = new Color(0x101010, false).setImmutable();
    @Nullable
    public static CustomRenderTarget framebuffer;

    public static void init() {
        RenderSystem.recordRenderCall(() -> {
            Window mainWindow = Minecraft.getInstance().getWindow();
            framebuffer = CustomRenderTarget.create(mainWindow);
        });
    }

    public static void updateWindowSize(Window mainWindow) {
        if (framebuffer != null) {
            framebuffer.resize(mainWindow.getWidth(), mainWindow.getHeight(), Minecraft.ON_OSX);
        }
    }

    public static void drawFramebuffer(PoseStack poseStack, float alpha) {
        if (framebuffer != null) {
            framebuffer.renderWithAlpha(poseStack, alpha);
        }
    }

    public static void swapAndBlitColor(RenderTarget src, RenderTarget dst) {
        GlStateManager._glBindFramebuffer((int)36008, (int)src.frameBufferId);
        GlStateManager._glBindFramebuffer((int)36009, (int)dst.frameBufferId);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)src.viewWidth, (int)src.viewHeight, (int)0, (int)0, (int)dst.viewWidth, (int)dst.viewHeight, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36160, (int)dst.frameBufferId);
    }

    public static void streak(GuiGraphics graphics, float angle, int x, int y, int breadth, int length) {
        UIRenderHelper.streak(graphics, angle, x, y, breadth, length, COLOR_STREAK);
    }

    public static void streak(GuiGraphics graphics, float angle, int x, int y, int breadth, int length, Color c) {
        Color color = c.copy().setImmutable();
        Color c1 = color.scaleAlpha(0.625f);
        Color c2 = color.scaleAlpha(0.5f);
        Color c3 = color.scaleAlpha(0.0625f);
        Color c4 = color.scaleAlpha(0.0f);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(angle - 90.0f));
        UIRenderHelper.streak(graphics, breadth / 2, length, c1, c2, c3, c4);
        poseStack.popPose();
    }

    private static void streak(GuiGraphics graphics, int width, int height, Color c1, Color c2, Color c3, Color c4) {
        if (NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            return;
        }
        double split1 = 0.5;
        double split2 = 0.75;
        graphics.fillGradient(-width, 0, width, (int)(split1 * (double)height), c1.getRGB(), c2.getRGB());
        graphics.fillGradient(-width, (int)(split1 * (double)height), width, (int)(split2 * (double)height), c2.getRGB(), c3.getRGB());
        graphics.fillGradient(-width, (int)(split2 * (double)height), width, height, c3.getRGB(), c4.getRGB());
    }

    public static void angledGradient(GuiGraphics graphics, float angle, int x, int y, float breadth, float length, Couple<Color> c) {
        UIRenderHelper.angledGradient(graphics, angle, x, y, 0, breadth, length, c);
    }

    public static void angledGradient(GuiGraphics graphics, float angle, int x, int y, int z, float breadth, float length, Couple<Color> c) {
        UIRenderHelper.angledGradient(graphics, angle, x, y, z, breadth, length, (Color)c.getFirst(), (Color)c.getSecond());
    }

    public static void angledGradient(GuiGraphics graphics, float angle, int x, int y, float breadth, float length, Color color1, Color color2) {
        UIRenderHelper.angledGradient(graphics, angle, x, y, 0, breadth, length, color1, color2);
    }

    public static void angledGradient(GuiGraphics graphics, float angle, int x, int y, int z, float breadth, float length, Color startColor, Color endColor) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, (float)z);
        poseStack.mulPose(Axis.ZP.rotationDegrees(angle - 90.0f));
        float w = breadth / 2.0f;
        UIRenderHelper.drawGradientRect(poseStack.last().pose(), 0, -w, 0.0f, w, length, startColor, endColor);
        poseStack.popPose();
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, float left, float top, float right, float bottom, Color startColor, Color endColor) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(mat, right, top, (float)zLevel).setColor(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha());
        buffer.addVertex(mat, left, top, (float)zLevel).setColor(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha());
        buffer.addVertex(mat, left, bottom, (float)zLevel).setColor(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha());
        buffer.addVertex(mat, right, bottom, (float)zLevel).setColor(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha());
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void breadcrumbArrow(GuiGraphics graphics, int x, int y, int z, int width, int height, int indent, Couple<Color> colors) {
        UIRenderHelper.breadcrumbArrow(graphics, x, y, z, width, height, indent, (Color)colors.getFirst(), (Color)colors.getSecond());
    }

    public static void breadcrumbArrow(GuiGraphics graphics, int x, int y, int z, int width, int height, int indent, Color startColor, Color endColor) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)(x - indent), (float)y, (float)z);
        UIRenderHelper.breadcrumbArrow(graphics, width, height, indent, startColor, endColor);
        poseStack.popPose();
    }

    private static void breadcrumbArrow(GuiGraphics graphics, int width, int height, int indent, Color c1, Color c2) {
        float x0 = 0.0f;
        float x1 = indent;
        float x2 = width;
        float x3 = indent + width;
        float y0 = 0.0f;
        float y1 = (float)height / 2.0f;
        float y2 = height;
        indent = Math.abs(indent);
        width = Math.abs(width);
        Color fc1 = Color.mixColors(c1, c2, 0.0f);
        Color fc2 = Color.mixColors(c1, c2, (float)indent / ((float)width + 2.0f * (float)indent));
        Color fc3 = Color.mixColors(c1, c2, (float)(indent + width) / ((float)width + 2.0f * (float)indent));
        Color fc4 = Color.mixColors(c1, c2, 1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f model = graphics.pose().last().pose();
        bufferbuilder.addVertex(model, x0, y1, 0.0f).setColor(fc1.getRed(), fc1.getGreen(), fc1.getBlue(), fc1.getAlpha());
        bufferbuilder.addVertex(model, x1, y0, 0.0f).setColor(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha());
        bufferbuilder.addVertex(model, x1, y1, 0.0f).setColor(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha());
        bufferbuilder.addVertex(model, x0, y1, 0.0f).setColor(fc1.getRed(), fc1.getGreen(), fc1.getBlue(), fc1.getAlpha());
        bufferbuilder.addVertex(model, x1, y1, 0.0f).setColor(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha());
        bufferbuilder.addVertex(model, x1, y2, 0.0f).setColor(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha());
        bufferbuilder.addVertex(model, x1, y2, 0.0f).setColor(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha());
        bufferbuilder.addVertex(model, x1, y0, 0.0f).setColor(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha());
        bufferbuilder.addVertex(model, x2, y0, 0.0f).setColor(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha());
        bufferbuilder.addVertex(model, x1, y2, 0.0f).setColor(fc2.getRed(), fc2.getGreen(), fc2.getBlue(), fc2.getAlpha());
        bufferbuilder.addVertex(model, x2, y0, 0.0f).setColor(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha());
        bufferbuilder.addVertex(model, x2, y2, 0.0f).setColor(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha());
        bufferbuilder.addVertex(model, x2, y1, 0.0f).setColor(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha());
        bufferbuilder.addVertex(model, x2, y0, 0.0f).setColor(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha());
        bufferbuilder.addVertex(model, x3, y0, 0.0f).setColor(fc4.getRed(), fc4.getGreen(), fc4.getBlue(), fc4.getAlpha());
        bufferbuilder.addVertex(model, x2, y2, 0.0f).setColor(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha());
        bufferbuilder.addVertex(model, x2, y1, 0.0f).setColor(fc3.getRed(), fc3.getGreen(), fc3.getBlue(), fc3.getAlpha());
        bufferbuilder.addVertex(model, x3, y2, 0.0f).setColor(fc4.getRed(), fc4.getGreen(), fc4.getBlue(), fc4.getAlpha());
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public static void drawRadialSector(GuiGraphics graphics, float innerRadius, float outerRadius, float startAngle, float arcAngle, Color innerColor, Color outerColor) {
        List<Point2D> innerPoints = UIRenderHelper.getPointsForCircleArc(innerRadius, startAngle, arcAngle);
        List<Point2D> outerPoints = UIRenderHelper.getPointsForCircleArc(outerRadius, startAngle, arcAngle);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f pose = graphics.pose().last().pose();
        Matrix3f n = graphics.pose().last().normal();
        for (int i = 0; i < innerPoints.size(); ++i) {
            Point2D point = outerPoints.get(i);
            builder.addVertex(pose, (float)point.getX(), (float)point.getY(), 0.0f).setColor(outerColor.getRGB());
            point = innerPoints.get(i);
            builder.addVertex(pose, (float)point.getX(), (float)point.getY(), 0.0f).setColor(innerColor.getRGB());
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private static List<Point2D> getPointsForCircleArc(float radius, float startAngle, float arcAngle) {
        int segmentCount = Math.abs(arcAngle) <= 90.0f ? 16 : 32;
        ArrayList<Point2D> points = new ArrayList<Point2D>(segmentCount);
        float theta = (float)Math.PI / 180 * arcAngle / (float)(segmentCount - 1);
        float t = (float)Math.PI / 180 * startAngle;
        for (int i = 0; i < segmentCount; ++i) {
            points.add(new Point2D.Float((float)((double)radius * Math.cos(t)), (float)((double)radius * Math.sin(t))));
            t += theta;
        }
        return points;
    }

    public static void drawColoredTexture(GuiGraphics graphics, Color c, int x, int y, int tex_left, int tex_top, int width, int height) {
        UIRenderHelper.drawColoredTexture(graphics, c, x, y, 0, tex_left, tex_top, width, height, 256, 256);
    }

    public static void drawColoredTexture(GuiGraphics graphics, Color c, int x, int y, int z, float tex_left, float tex_top, int width, int height, int sheet_width, int sheet_height) {
        UIRenderHelper.drawColoredTexture(graphics, c, x, x + width, y, y + height, z, width, height, tex_left, tex_top, sheet_width, sheet_height);
    }

    public static void drawStretched(GuiGraphics graphics, int left, int top, int w, int h, int z, TextureSheetSegment tex) {
        tex.bind();
        UIRenderHelper.drawTexturedQuad(graphics.pose().last().pose(), Color.WHITE, left, left + w, top, top + h, z, (float)tex.getStartX() / 256.0f, (float)(tex.getStartX() + tex.getWidth()) / 256.0f, (float)tex.getStartY() / 256.0f, (float)(tex.getStartY() + tex.getHeight()) / 256.0f);
    }

    public static void drawCropped(GuiGraphics graphics, int left, int top, int w, int h, int z, TextureSheetSegment tex) {
        tex.bind();
        UIRenderHelper.drawTexturedQuad(graphics.pose().last().pose(), Color.WHITE, left, left + w, top, top + h, z, (float)tex.getStartX() / 256.0f, (float)(tex.getStartX() + w) / 256.0f, (float)tex.getStartY() / 256.0f, (float)(tex.getStartY() + h) / 256.0f);
    }

    private static void drawColoredTexture(GuiGraphics graphics, Color c, int left, int right, int top, int bot, int z, int tex_width, int tex_height, float tex_left, float tex_top, int sheet_width, int sheet_height) {
        UIRenderHelper.drawTexturedQuad(graphics.pose().last().pose(), c, left, right, top, bot, z, (tex_left + 0.0f) / (float)sheet_width, (tex_left + (float)tex_width) / (float)sheet_width, (tex_top + 0.0f) / (float)sheet_height, (tex_top + (float)tex_height) / (float)sheet_height);
    }

    private static void drawTexturedQuad(Matrix4f m, Color c, int left, int right, int top, int bot, int z, float u1, float u2, float v1, float v2) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        bufferbuilder.addVertex(m, (float)left, (float)bot, (float)z).setColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).setUv(u1, v2);
        bufferbuilder.addVertex(m, (float)right, (float)bot, (float)z).setColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).setUv(u2, v2);
        bufferbuilder.addVertex(m, (float)right, (float)top, (float)z).setColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).setUv(u2, v1);
        bufferbuilder.addVertex(m, (float)left, (float)top, (float)z).setColor(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).setUv(u1, v1);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void flipForGuiRender(PoseStack poseStack) {
        poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
    }

    public static class CustomRenderTarget
    extends RenderTarget {
        public CustomRenderTarget(boolean useDepth) {
            super(useDepth);
        }

        public static CustomRenderTarget create(Window mainWindow) {
            CustomRenderTarget framebuffer = new CustomRenderTarget(true);
            framebuffer.resize(mainWindow.getWidth(), mainWindow.getHeight(), Minecraft.ON_OSX);
            framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            CatnipClientServices.CLIENT_HOOKS.enableStencilBuffer(framebuffer);
            return framebuffer;
        }

        public void renderWithAlpha(PoseStack poseStack, float alpha) {
            Window window = Minecraft.getInstance().getWindow();
            float guiScaledWidth = window.getGuiScaledWidth();
            float guiScaledHeight = window.getGuiScaledHeight();
            float vx = guiScaledWidth;
            float vy = guiScaledHeight;
            float tx = (float)this.viewWidth / (float)this.width;
            float ty = (float)this.viewHeight / (float)this.height;
            RenderSystem.disableDepthTest();
            Minecraft minecraft = Minecraft.getInstance();
            ShaderInstance shaderinstance = minecraft.gameRenderer.blitShader;
            shaderinstance.setSampler("DiffuseSampler", (Object)this.colorTextureId);
            Matrix4f matrix4f = poseStack.last().pose();
            Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            if (shaderinstance.MODEL_VIEW_MATRIX != null) {
                shaderinstance.MODEL_VIEW_MATRIX.set(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
            }
            if (shaderinstance.PROJECTION_MATRIX != null) {
                shaderinstance.PROJECTION_MATRIX.set(matrix4f);
            }
            shaderinstance.apply();
            Tesselator tesselator = RenderSystem.renderThreadTesselator();
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferbuilder.addVertex(0.0f, vy, 0.0f).setUv(0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.addVertex(vx, vy, 0.0f).setUv(tx, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.addVertex(vx, 0.0f, 0.0f).setUv(tx, ty).setColor(1.0f, 1.0f, 1.0f, alpha);
            bufferbuilder.addVertex(0.0f, 0.0f, 0.0f).setUv(0.0f, ty).setColor(1.0f, 1.0f, 1.0f, alpha);
            BufferUploader.draw((MeshData)bufferbuilder.buildOrThrow());
            shaderinstance.clear();
            RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        }
    }
}

