/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.TickableGuiEventListener;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.mixin.client.accessor.ScreenAccessor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public abstract class AbstractSimiScreen
extends Screen {
    protected static final Color BACKGROUND_COLOR = new Color(0x50101010, true);
    protected int windowWidth;
    protected int windowHeight;
    protected int windowXOffset;
    protected int windowYOffset;
    protected int guiLeft;
    protected int guiTop;

    protected AbstractSimiScreen(Component title) {
        super(title);
    }

    protected AbstractSimiScreen() {
        this(CommonComponents.EMPTY);
    }

    protected void setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void init() {
        this.guiLeft = (this.width - this.windowWidth) / 2;
        this.guiTop = (this.height - this.windowHeight) / 2;
        this.guiLeft += this.windowXOffset;
        this.guiTop += this.windowYOffset;
    }

    public void tick() {
        for (GuiEventListener listener : this.children()) {
            if (!(listener instanceof TickableGuiEventListener)) continue;
            TickableGuiEventListener tickable = (TickableGuiEventListener)listener;
            tickable.tick();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(W ... widgets) {
        for (W widget : widgets) {
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    protected <W extends GuiEventListener & Renderable> void addRenderableWidgets(Collection<W> widgets) {
        for (GuiEventListener widget : widgets) {
            this.addRenderableWidget(widget);
        }
    }

    protected void removeWidgets(GuiEventListener ... widgets) {
        for (GuiEventListener widget : widgets) {
            this.removeWidget(widget);
        }
    }

    protected void removeWidgets(Collection<? extends GuiEventListener> widgets) {
        for (GuiEventListener guiEventListener : widgets) {
            this.removeWidget(guiEventListener);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = NavigatableSimiScreen.currentlyRenderingPreviousScreen ? 0.0f : AnimationTickHolder.getPartialTicksUI();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        this.prepareFrame();
        this.renderMenuBackground(graphics);
        this.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
        this.renderWindow(graphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.getRenderables()) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
        this.endFrame();
        poseStack.popPose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean keyPressed = super.keyPressed(keyCode, scanCode, modifiers);
        if (keyPressed || this.getFocused() != null) {
            return keyPressed;
        }
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        boolean consumed = false;
        for (GuiEventListener widget : this.children()) {
            AbstractSimiWidget simiWidget;
            if (!(widget instanceof AbstractSimiWidget) || !(simiWidget = (AbstractSimiWidget)widget).keyPressed(keyCode, scanCode, modifiers)) continue;
            consumed = true;
        }
        return consumed;
    }

    protected void prepareFrame() {
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
    }

    protected abstract void renderWindow(GuiGraphics var1, int var2, int var3, float var4);

    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        for (Renderable widget : this.getRenderables()) {
            List<Component> tooltip;
            AbstractSimiWidget simiWidget;
            if (!(widget instanceof AbstractSimiWidget) || !(simiWidget = (AbstractSimiWidget)widget).isHovered() || !simiWidget.visible || (tooltip = simiWidget.getToolTip()).isEmpty()) continue;
            int ttx = simiWidget.lockedTooltipX == -1 ? mouseX : simiWidget.lockedTooltipX + simiWidget.getX();
            int tty = simiWidget.lockedTooltipY == -1 ? mouseY : simiWidget.lockedTooltipY + simiWidget.getY();
            graphics.renderComponentTooltip(this.font, tooltip, ttx, tty);
        }
    }

    protected void endFrame() {
    }

    @Deprecated
    protected void debugWindowArea(GuiGraphics graphics) {
        graphics.fill(this.guiLeft + this.windowWidth, this.guiTop + this.windowHeight, this.guiLeft, this.guiTop, -741092397);
    }

    protected List<Renderable> getRenderables() {
        return ((ScreenAccessor)((Object)this)).catnip$getRenderables();
    }

    public GuiEventListener getFocused() {
        GuiEventListener focused = super.getFocused();
        if (focused instanceof AbstractWidget && !focused.isFocused()) {
            focused = null;
        }
        this.setFocused(focused);
        return focused;
    }
}

