/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.ghostblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.ghostblock.GhostBlockParams;
import net.createmod.catnip.placement.PlacementClient;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class GhostBlockRenderer {
    private static final GhostBlockRenderer STANDARD = new DefaultGhostBlockRenderer();
    private static final GhostBlockRenderer TRANSPARENT = new TransparentGhostBlockRenderer();

    public static GhostBlockRenderer standard() {
        return STANDARD;
    }

    public static GhostBlockRenderer transparent() {
        return TRANSPARENT;
    }

    public abstract void render(PoseStack var1, SuperRenderTypeBuffer var2, Vec3 var3, GhostBlockParams var4);

    private static class DefaultGhostBlockRenderer
    extends GhostBlockRenderer {
        private DefaultGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, GhostBlockParams params) {
            ms.pushPose();
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            BlockState state = params.state;
            BakedModel model = dispatcher.getBlockModel(state);
            BlockPos pos = params.pos;
            ms.translate((double)pos.getX() - camera.x, (double)pos.getY() - camera.y, (double)pos.getZ() - camera.z);
            for (RenderType layer : CatnipClientServices.CLIENT_HOOKS.getRenderTypesForBlockModel(state, RandomSource.create((long)42L), null)) {
                VertexConsumer vb = buffer.getEarlyBuffer(layer);
                CatnipClientServices.CLIENT_HOOKS.renderVirtualBlockStateModel(dispatcher, ms, vb, state, model, 1.0f, 1.0f, 1.0f, layer);
            }
            ms.popPose();
        }
    }

    private static class TransparentGhostBlockRenderer
    extends GhostBlockRenderer {
        private TransparentGhostBlockRenderer() {
        }

        @Override
        public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, GhostBlockParams params) {
            ms.pushPose();
            Minecraft mc = Minecraft.getInstance();
            BlockRenderDispatcher dispatcher = mc.getBlockRenderer();
            BakedModel model = dispatcher.getBlockModel(params.state);
            RenderType layer = RenderType.translucent();
            VertexConsumer vb = buffer.getEarlyBuffer(layer);
            BlockPos pos = params.pos;
            ms.translate((double)pos.getX() - camera.x, (double)pos.getY() - camera.y, (double)pos.getZ() - camera.z);
            ms.translate(0.5, 0.5, 0.5);
            ms.scale(0.85f, 0.85f, 0.85f);
            ms.translate(-0.5, -0.5, -0.5);
            float alpha = params.alphaSupplier.get().floatValue() * 0.75f * PlacementClient.getCurrentAlpha();
            this.renderModel(ms.last(), vb, params.state, model, 1.0f, 1.0f, 1.0f, alpha, LevelRenderer.getLightColor((BlockAndTintGetter)mc.level, (BlockPos)pos), OverlayTexture.NO_OVERLAY);
            ms.popPose();
        }

        public void renderModel(PoseStack.Pose pose, VertexConsumer consumer, @Nullable BlockState state, BakedModel model, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
            RandomSource random = RandomSource.create();
            for (Direction direction : Direction.values()) {
                random.setSeed(42L);
                TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.getQuads(state, direction, random), packedLight, packedOverlay);
            }
            random.setSeed(42L);
            TransparentGhostBlockRenderer.renderQuadList(pose, consumer, red, green, blue, alpha, model.getQuads(state, null, random), packedLight, packedOverlay);
        }

        private static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, float red, float green, float blue, float alpha, List<BakedQuad> quads, int packedLight, int packedOverlay) {
            for (BakedQuad quad : quads) {
                float f2;
                float f1;
                float f;
                if (quad.isTinted()) {
                    f = Mth.clamp((float)red, (float)0.0f, (float)1.0f);
                    f1 = Mth.clamp((float)green, (float)0.0f, (float)1.0f);
                    f2 = Mth.clamp((float)blue, (float)0.0f, (float)1.0f);
                } else {
                    f = 1.0f;
                    f1 = 1.0f;
                    f2 = 1.0f;
                }
                CatnipClientServices.CLIENT_HOOKS.vertexConsumerPutBulkDataWithAlpha(consumer, pose, quad, f, f1, f2, alpha, packedLight, packedOverlay);
            }
        }
    }
}

