/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.codec.StreamCodec;

public class Pair<F, S> {
    F first;
    S second;

    protected Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public static <F, S> Pair<F, S> of(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public void setFirst(F first) {
        this.first = first;
    }

    public void setSecond(S second) {
        this.second = second;
    }

    public Pair<F, S> copy() {
        return Pair.of(this.first, this.second);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair other = (Pair)obj;
            return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
        }
        return false;
    }

    public int hashCode() {
        return this.nullHash(this.first) * 31 ^ this.nullHash(this.second);
    }

    int nullHash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public String toString() {
        return "(" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ")";
    }

    public Pair<S, F> swap() {
        return Pair.of(this.second, this.first);
    }

    public static <F, S> Codec<Pair<F, S>> codec(Codec<F> firstCodec, Codec<S> secondCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)firstCodec.fieldOf("first").forGetter(Pair::getFirst), (App)secondCodec.fieldOf("second").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::new));
    }

    public static <B, F, S> StreamCodec<B, Pair<F, S>> streamCodec(StreamCodec<? super B, F> firstCodec, StreamCodec<? super B, S> secondCodec) {
        return StreamCodec.composite(firstCodec, Pair::getFirst, secondCodec, Pair::getSecond, Pair::new);
    }
}

