/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.Force;
import net.createmod.catnip.animation.PhysicalFloat;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.TriConsumer;

public abstract class ConfigScreen
extends AbstractSimiScreen {
    public static final List<UnaryOperator<String>> displayNameKeys = List.of(modID -> "catnip." + modID + ".display_name", modID -> "constants." + modID + ".mod_name", modID -> "itemGroup." + modID + ".base", modID -> "itemGroup." + modID + "." + modID);
    public static final Map<String, String> knownModDisplayNames = Map.ofEntries(Map.entry("forge", "Forge"), Map.entry("jei", "Just Enough Items"), Map.entry("computercraft", "ComputerCraft"), Map.entry("catnip", "Catnip"), Map.entry("ponder", "Ponder"), Map.entry("create", "Create"), Map.entry("flywheel", "Flywheel"), Map.entry("ae2", "Applied Energistics 2"));
    public static final Map<String, TriConsumer<Screen, GuiGraphics, Float>> backgrounds = new HashMap<String, TriConsumer<Screen, GuiGraphics, Float>>();
    public static final PhysicalFloat cogSpin = PhysicalFloat.create().withLimit(10.0f).withDrag(0.3).addForce(new Force.Static(0.2f));
    @Nullable
    public static String modID = null;
    @Nullable
    protected final Screen parent;
    public static BlockState shadowState = Blocks.POTTED_CRIMSON_ROOTS.defaultBlockState();
    public static DelegatedStencilElement shadowElement = new DelegatedStencilElement((graphics, x, y, alpha) -> ConfigScreen.renderCog(graphics), (graphics, x, y, alpha) -> graphics.fill(-200, -200, 200, 200, 0x60000000));
    private static final PanoramaRenderer vanillaPanorama = new PanoramaRenderer(TitleScreen.CUBE_MAP);

    public ConfigScreen(@Nullable Screen parent) {
        this.parent = parent;
    }

    @Override
    public void tick() {
        super.tick();
        cogSpin.tick();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.minecraft != null && this.minecraft.level != null) {
            graphics.fill(0, 0, this.width, this.height, -1339544524);
        } else {
            this.renderMenuBackground(graphics, partialTicks);
        }
        shadowElement.at((float)this.width * 0.5f, (float)this.height * 0.5f, 0.0f).render(graphics);
        super.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor(this.minecraft.getMainRenderTarget(), UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)Minecraft.ON_OSX);
    }

    @Override
    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor(UIRenderHelper.framebuffer, this.minecraft.getMainRenderTarget());
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        cogSpin.bump(3, -scrollY * 5.0);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    public static Optional<String> getModDisplayName(String modID) {
        Optional<String> displayNameFromLang = displayNameKeys.stream().map(op -> (String)op.apply(modID)).filter(I18n::exists).findFirst().map(x$0 -> I18n.get((String)x$0, (Object[])new Object[0]));
        if (displayNameFromLang.isPresent()) {
            return displayNameFromLang;
        }
        return Optional.ofNullable(knownModDisplayNames.get(modID));
    }

    public static String toHumanReadable(String key) {
        String s = key.replaceAll("_", " ");
        s = Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)s)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        s = StringUtils.normalizeSpace((String)s);
        return s;
    }

    protected void renderMenuBackground(GuiGraphics graphics, float partialTicks) {
        TriConsumer<Screen, GuiGraphics, Float> customBackground = backgrounds.get(modID);
        if (customBackground != null) {
            customBackground.accept((Object)this, (Object)graphics, (Object)Float.valueOf(partialTicks));
            return;
        }
        vanillaPanorama.render(graphics, this.width, this.height, 1.0f, partialTicks);
        graphics.fill(0, 0, this.width, this.height, -1876415436);
    }

    protected static void renderCog(GuiGraphics graphics) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(-100.0f, 100.0f, -100.0f);
        poseStack.scale(200.0f, 200.0f, 1.0f);
        GuiGameElement.of(shadowState).rotateBlock(22.5, cogSpin.getValue(partialTicks), 22.5).render(graphics);
        poseStack.popPose();
    }
}

