/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.ConfigScreenList;
import net.createmod.catnip.config.ui.HintableTextFieldWidget;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigModListScreen
extends ConfigScreen {
    @Nullable
    ConfigScreenList list;
    @Nullable
    HintableTextFieldWidget search;
    @Nullable
    BoxWidget goBack;
    List<ModEntry> allEntries = new ArrayList<ModEntry>();

    public ConfigModListScreen(@Nullable Screen parent) {
        super(parent);
    }

    @Override
    protected void init() {
        super.init();
        int listWidth = Math.min(this.width - 80, 300);
        this.list = new ConfigScreenList(this.minecraft, listWidth, this.height - 60, 15, 40);
        this.list.setX(this.width / 2 - this.list.getWidth() / 2);
        this.addRenderableWidget(this.list);
        this.allEntries = new ArrayList<ModEntry>();
        CatnipServices.PLATFORM.getLoadedMods().forEach(id -> this.allEntries.add(new ModEntry((String)id, this)));
        this.allEntries.sort((e1, e2) -> {
            int empty = (e2.button.active ? 1 : 0) - (e1.button.active ? 1 : 0);
            if (empty != 0) {
                return empty;
            }
            return e1.id.compareToIgnoreCase(e2.id);
        });
        this.list.children().clear();
        this.list.children().addAll(this.allEntries);
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.width / 2 - listWidth / 2 - 30, this.height / 2 + 65, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> ScreenOpener.open(this.parent));
        this.goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((Component)Component.literal((String)"Go Back"));
        this.addRenderableWidget(this.goBack);
        this.search = new HintableTextFieldWidget(this.font, this.width / 2 - listWidth / 2, this.height - 35, listWidth, 20);
        this.search.setResponder(this::updateFilter);
        this.search.setHint("Ctrl + F to Search...");
        this.search.moveCursorToStart(false);
        this.addRenderableWidget((GuiEventListener)this.search);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.search != null && !this.search.isMouseOver(x, y)) {
            this.search.setFocused(false);
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.search != null && Screen.hasControlDown() && keyCode == 70) {
            this.setFocused((GuiEventListener)this.search);
        }
        if (keyCode == 259) {
            ScreenOpener.open(this.parent);
        }
        return false;
    }

    private void updateFilter(String search) {
        assert (this.list != null);
        assert (this.search != null);
        this.list.children().clear();
        for (ModEntry modEntry : this.allEntries) {
            if (!modEntry.id.contains(search.toLowerCase(Locale.ROOT))) continue;
            this.list.children().add(modEntry);
        }
        this.list.setScrollAmount(this.list.getScrollAmount());
        if (!this.list.children().isEmpty()) {
            this.search.setTextColor(((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        } else {
            this.search.setTextColor(((Color)AbstractSimiWidget.COLOR_FAIL.getFirst()).getRGB());
        }
    }

    public static class ModEntry
    extends ConfigScreenList.LabeledEntry {
        protected BoxWidget button;
        protected String id;

        public ModEntry(String id, Screen parent) {
            super(ModEntry.modName(id));
            this.id = id;
            this.button = (BoxWidget)new BoxWidget(0, 0, 35, 16).showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_OPEN.asStencil().at(10.0f, 0.0f));
            this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.button)));
            if (ConfigHelper.hasAnyForgeConfig(id)) {
                this.button.withCallback(() -> ScreenOpener.open(new BaseConfigScreen(parent, id)));
            } else {
                this.button.active = false;
                this.button.updateGradientFromState();
                this.button.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BaseConfigScreen.DISABLED_RENDERER));
                this.labelTooltip.add(Component.literal((String)ModEntry.modName(id)));
                this.labelTooltip.addAll(FontHelper.cutTextComponent((Component)Component.literal((String)"This Mod does not have any configs registered or is not using Forge's config system"), FontHelper.Palette.ALL_GRAY));
            }
            this.listeners.add(this.button);
        }

        private static String modName(String modID) {
            return ConfigScreen.getModDisplayName(modID).orElse(ConfigScreen.toHumanReadable(modID));
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void tick() {
            super.tick();
            this.button.tick();
        }

        @Override
        public void render(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.render(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.setX(x + width - 108);
            this.button.setY(y + 10);
            this.button.setHeight(height - 20);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }
    }
}

