/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigModListScreen;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.SubMenuConfigScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.element.TextStencilElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class BaseConfigScreen
extends ConfigScreen {
    public static final Color COLOR_TITLE_A = new Color(-3760196).setImmutable();
    public static final Color COLOR_TITLE_B = new Color(-608069).setImmutable();
    public static final Color COLOR_TITLE_C = new Color(-263788).setImmutable();
    public static final FadableScreenElement DISABLED_RENDERER = (ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, AbstractSimiWidget.COLOR_DISABLED);
    private static final Map<String, UnaryOperator<BaseConfigScreen>> DEFAULTS = new HashMap<String, UnaryOperator<BaseConfigScreen>>();
    @Nullable
    BoxWidget clientConfigWidget;
    @Nullable
    BoxWidget commonConfigWidget;
    @Nullable
    BoxWidget serverConfigWidget;
    @Nullable
    BoxWidget goBack;
    @Nullable
    BoxWidget others;
    @Nullable
    BoxWidget title;
    @Nullable
    ModConfigSpec clientSpec;
    @Nullable
    ModConfigSpec commonSpec;
    @Nullable
    ModConfigSpec serverSpec;
    String clientButtonLabel = "Client Config";
    String commonButtonLabel = "Common Config";
    String serverButtonLabel = "Server Config";
    String modID;
    protected boolean returnOnClose;

    public static void setDefaultActionFor(String modID, UnaryOperator<BaseConfigScreen> transform) {
        DEFAULTS.put(modID, transform);
    }

    public BaseConfigScreen(@Nullable Screen parent, String modID) {
        super(parent);
        this.modID = modID;
        if (DEFAULTS.containsKey(modID)) {
            DEFAULTS.get(modID).apply(this);
        } else {
            this.searchForConfigSpecs();
        }
    }

    public BaseConfigScreen searchForConfigSpecs() {
        if (!ConfigHelper.hasAnyForgeConfig(this.modID)) {
            return this;
        }
        try {
            this.clientSpec = ConfigHelper.findModConfigSpecFor(ModConfig.Type.CLIENT, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find ClientConfigSpec for mod: " + this.modID);
        }
        try {
            this.commonSpec = ConfigHelper.findModConfigSpecFor(ModConfig.Type.COMMON, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find CommonConfigSpec for mod: " + this.modID);
        }
        try {
            this.serverSpec = ConfigHelper.findModConfigSpecFor(ModConfig.Type.SERVER, this.modID);
        }
        catch (ClassCastException | NullPointerException e) {
            Ponder.LOGGER.debug("Unable to find ServerConfigSpec for mod: " + this.modID);
        }
        return this;
    }

    public BaseConfigScreen withSpecs(@Nullable ModConfigSpec client, @Nullable ModConfigSpec common, @Nullable ModConfigSpec server) {
        this.clientSpec = client;
        this.commonSpec = common;
        this.serverSpec = server;
        return this;
    }

    public BaseConfigScreen withButtonLabels(@Nullable String client, @Nullable String common, @Nullable String server) {
        if (client != null) {
            this.clientButtonLabel = client;
        }
        if (common != null) {
            this.commonButtonLabel = common;
        }
        if (server != null) {
            this.serverButtonLabel = server;
        }
        return this;
    }

    @Override
    protected void init() {
        super.init();
        this.returnOnClose = true;
        TextStencilElement clientText = new TextStencilElement(this.font, Component.literal((String)this.clientButtonLabel)).centered(true, true);
        this.clientConfigWidget = (BoxWidget)new BoxWidget(this.width / 2 - 100, this.height / 2 - 15 - 30, 200, 16).showingElement(clientText);
        this.addRenderableWidget(this.clientConfigWidget);
        if (this.clientSpec != null) {
            this.clientConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.CLIENT, this.clientSpec)));
            clientText.withElementRenderer(BoxWidget.gradientFactory.apply(this.clientConfigWidget));
        } else {
            this.clientConfigWidget.active = false;
            this.clientConfigWidget.updateGradientFromState();
            clientText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement commonText = new TextStencilElement(this.font, Component.literal((String)this.commonButtonLabel)).centered(true, true);
        this.commonConfigWidget = (BoxWidget)new BoxWidget(this.width / 2 - 100, this.height / 2 - 15, 200, 16).showingElement(commonText);
        this.addRenderableWidget(this.commonConfigWidget);
        if (this.commonSpec != null) {
            this.commonConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.COMMON, this.commonSpec)));
            commonText.withElementRenderer(BoxWidget.gradientFactory.apply(this.commonConfigWidget));
        } else {
            this.commonConfigWidget.active = false;
            this.commonConfigWidget.updateGradientFromState();
            commonText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement serverText = new TextStencilElement(this.font, Component.literal((String)this.serverButtonLabel)).centered(true, true);
        this.serverConfigWidget = (BoxWidget)new BoxWidget(this.width / 2 - 100, this.height / 2 - 15 + 30, 200, 16).showingElement(serverText);
        this.addRenderableWidget(this.serverConfigWidget);
        if (this.serverSpec == null) {
            this.serverConfigWidget.active = false;
            this.serverConfigWidget.updateGradientFromState();
            serverText.withElementRenderer(DISABLED_RENDERER);
        } else if (this.minecraft.level == null) {
            serverText.withElementRenderer(DISABLED_RENDERER);
            this.serverConfigWidget.getToolTip().add((Component)Component.literal((String)"Stored individually per World"));
            this.serverConfigWidget.getToolTip().addAll(FontHelper.cutTextComponent((Component)Component.literal((String)"Gameplay settings can only be accessed from the in-game menu after joining a World or Server."), FontHelper.Palette.ALL_GRAY));
        } else {
            this.serverConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.SERVER, this.serverSpec)));
            serverText.withElementRenderer(BoxWidget.gradientFactory.apply(this.serverConfigWidget));
        }
        TextStencilElement titleText = (TextStencilElement)new TextStencilElement(this.font, BaseConfigScreen.getModDisplayName(this.modID).orElse(this.modID.toLowerCase(Locale.ROOT))).centered(true, true).withElementRenderer((ms, w, h, alpha) -> {
            UIRenderHelper.angledGradient(ms, 0.0f, 0, h / 2, (float)h, (float)(w / 2), COLOR_TITLE_A, COLOR_TITLE_B);
            UIRenderHelper.angledGradient(ms, 0.0f, w / 2, h / 2, (float)h, (float)(w / 2), COLOR_TITLE_B, COLOR_TITLE_C);
        });
        int boxWidth = this.width + 10;
        int boxHeight = 39;
        int boxPadding = 4;
        this.title = (BoxWidget)((ElementWidget)((ElementWidget)((ElementWidget)((BoxWidget)new BoxWidget(-5, this.height / 2 - 110, boxWidth, boxHeight).setActive(false)).withBorderColors(AbstractSimiWidget.COLOR_IDLE)).withPadding(0.0f, boxPadding)).rescaleElement((float)boxWidth / 2.0f, (float)(boxHeight - 2 * boxPadding) / 2.0f)).showingElement((RenderElement)titleText.at(0.0f, 7.0f));
        this.addRenderableWidget(this.title);
        ConfigScreen.modID = this.modID;
        this.goBack = (BoxWidget)((AbstractSimiWidget)new BoxWidget(this.width / 2 - 134, this.height / 2, 20, 20).withPadding(2.0f, 2.0f)).withCallback(() -> this.linkTo(this.parent));
        this.goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((Component)Component.literal((String)"Go Back"));
        this.addRenderableWidget(this.goBack);
        TextStencilElement othersText = new TextStencilElement(this.font, Component.literal((String)"Access Configs of other Mods")).centered(true, true);
        this.others = (BoxWidget)new BoxWidget(this.width / 2 - 100, this.height / 2 - 15 + 90, 200, 16).showingElement(othersText);
        othersText.withElementRenderer(BoxWidget.gradientFactory.apply(this.others));
        this.others.withCallback(() -> this.linkTo(new ConfigModListScreen(this)));
        this.addRenderableWidget(this.others);
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.drawCenteredString(this.font, "Access Configs for Mod:", this.width / 2, this.height / 2 - 105, ((Color)UIRenderHelper.COLOR_TEXT_STRONG_ACCENT.getFirst()).getRGB());
    }

    private void linkTo(@Nullable Screen screen) {
        this.returnOnClose = false;
        ScreenOpener.open(screen);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 259) {
            this.linkTo(this.parent);
        }
        return false;
    }
}

