/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.net.ConfigPathArgument;
import net.createmod.catnip.net.packets.ClientboundConfigPacket;
import net.createmod.catnip.net.packets.ClientboundSimpleActionPacket;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.ponder.Ponder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.config.ModConfig;

public class ConfigCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"config").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            CatnipServices.NETWORK.sendToClient(player, new ClientboundSimpleActionPacket("configScreen", ""));
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"path", (ArgumentType)ConfigPathArgument.path()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            CatnipServices.NETWORK.sendToClient(player, new ClientboundSimpleActionPacket("configScreen", ConfigPathArgument.getPath((CommandContext<CommandSourceStack>)ctx, "path").toString()));
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ConfigHelper.ConfigPath path = ConfigPathArgument.getPath((CommandContext<CommandSourceStack>)ctx, "path");
            String value = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            if (path.getType() == ModConfig.Type.CLIENT) {
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                CatnipServices.NETWORK.sendToClient(player, new ClientboundConfigPacket(path.toString(), value));
                return 1;
            }
            try {
                ConfigHelper.setConfigValue(path, value);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Great Success!"), false);
                return 1;
            }
            catch (ConfigHelper.InvalidValueException e) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Config could not be set the the specified value!"));
                return 0;
            }
            catch (Exception e) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Something went wrong while trying to set config value. Check the server logs for more information"));
                Ponder.LOGGER.warn("Exception during server-side config value set:", (Throwable)e);
                return 0;
            }
        }))));
    }
}

