/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.codecs.stream;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CatnipStreamCodecBuilders {
    public static <T extends ByteBuf, S extends Enum<S>> StreamCodec<T, S> ofEnum(final Class<S> clazz) {
        return new StreamCodec<T, S>(){

            @NotNull
            public S decode(@NotNull T buffer) {
                return ((Enum[])clazz.getEnumConstants())[VarInt.read(buffer)];
            }

            public void encode(@NotNull T buffer, @NotNull S value) {
                VarInt.write(buffer, (int)((Enum)value).ordinal());
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Pair<L, R>> pair(final StreamCodec<B, L> codecL, final StreamCodec<B, R> codecR) {
        return new StreamCodec<B, Pair<L, R>>(){

            @NotNull
            public Pair<L, R> decode(B buffer) {
                Object l = codecL.decode(buffer);
                Object r = codecR.decode(buffer);
                return Pair.of((Object)l, (Object)r);
            }

            public void encode(B buffer, Pair<L, R> value) {
                codecL.encode(buffer, value.getFirst());
                codecR.encode(buffer, value.getSecond());
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, Optional<V>> optional() {
        return ByteBufCodecs::optional;
    }

    public static <B extends ByteBuf, V> StreamCodec<B, @Nullable V> nullable(final StreamCodec<B, V> base) {
        return new StreamCodec<B, V>(){

            @Nullable
            public V decode(@NotNull B buffer) {
                return FriendlyByteBuf.readNullable(buffer, (StreamDecoder)base);
            }

            public void encode(@NotNull B buffer, @Nullable V value) {
                FriendlyByteBuf.writeNullable(buffer, value, (StreamEncoder)base);
            }
        };
    }

    public static <B extends ByteBuf, V> // Could not load outer class - annotation placement on inner may be incorrect
    StreamCodec.CodecOperation<B, V, @Nullable V> nullable() {
        return CatnipStreamCodecBuilders::nullable;
    }

    public static <B extends ByteBuf, V> StreamCodec<B, List<V>> list(StreamCodec<B, V> base) {
        return base.apply(ByteBufCodecs.list());
    }

    public static <B extends ByteBuf, V> StreamCodec<B, List<V>> list(StreamCodec<B, V> base, int maxSize) {
        return base.apply(ByteBufCodecs.list((int)maxSize));
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, NonNullList<V>> nonNullList() {
        return streamCodec -> ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)streamCodec);
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, NonNullList<V>> nonNullList(int maxSize) {
        return streamCodec -> ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)streamCodec, (int)maxSize);
    }

    public static <B extends ByteBuf, V> StreamCodec<B, NonNullList<V>> nonNullList(StreamCodec<B, V> base) {
        return base.apply(CatnipStreamCodecBuilders.nonNullList());
    }

    public static <B extends ByteBuf, V> StreamCodec<B, NonNullList<V>> nonNullList(StreamCodec<B, V> base, int maxSize) {
        return base.apply(CatnipStreamCodecBuilders.nonNullList(maxSize));
    }

    public static <B extends FriendlyByteBuf, V> StreamCodec<B, V[]> array(final StreamCodec<? super B, V> base, final Class<?> clazz) {
        return new StreamCodec<B, V[]>(){

            public V @NotNull [] decode(@NotNull B buffer) {
                int size = buffer.readVarInt();
                Object[] array = (Object[])Array.newInstance(clazz, size);
                for (int i = 0; i < size; ++i) {
                    array[i] = base.decode(buffer);
                }
                return array;
            }

            public void encode(@NotNull B buffer, @NotNull V[] value) {
                buffer.writeVarInt(value.length);
                for (Object v : value) {
                    base.encode(buffer, v);
                }
            }
        };
    }

    public static <B extends FriendlyByteBuf, V> StreamCodec.CodecOperation<B, V, V[]> array(Class<?> clazz) {
        return streamCodec -> CatnipStreamCodecBuilders.array(streamCodec, clazz);
    }

    public static <T> StreamCodec<ByteBuf, TagKey<T>> tagKey(ResourceKey<? extends Registry<T>> registry) {
        return ResourceLocation.STREAM_CODEC.map(id -> TagKey.create((ResourceKey)registry, (ResourceLocation)id), TagKey::location);
    }
}

