/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.codecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;

public interface CatnipCodecUtils {
    public static <T> Optional<T> decode(Codec<T> codec, Tag tag) {
        return CatnipCodecUtils.decode(codec, NbtOps.INSTANCE, tag);
    }

    public static <T> Optional<T> decode(Codec<T> codec, HolderLookup.Provider registries, Tag tag) {
        return CatnipCodecUtils.decode(codec, RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), tag);
    }

    public static <T, S> Optional<T> decode(Codec<T> codec, DynamicOps<S> ops, S s) {
        return Optional.ofNullable(codec.decode(ops, s).mapOrElse(Pair::getFirst, error -> null));
    }

    public static <T> Optional<Tag> encode(Codec<T> codec, T t) {
        return CatnipCodecUtils.encode(codec, NbtOps.INSTANCE, t);
    }

    public static <T> Optional<Tag> encode(Codec<T> codec, HolderLookup.Provider registries, T t) {
        return CatnipCodecUtils.encode(codec, RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), t);
    }

    public static <T, S> Optional<S> encode(Codec<T> codec, DynamicOps<S> ops, T t) {
        return Optional.ofNullable(codec.encodeStart(ops, t).mapOrElse(tag -> tag, error -> null));
    }
}

