/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.IContainerFactory;

public abstract class CorpseContainerFactory<T extends CorpseContainerBase>
implements IContainerFactory<T> {
    public T create(int windowId, Inventory inv, RegistryFriendlyByteBuf buffer) {
        boolean isHistory = buffer.readBoolean();
        boolean additionalItemsEmpty = buffer.readBoolean();
        if (isHistory) {
            Death death = Death.fromNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            if (!additionalItemsEmpty) {
                death.getAdditionalItems().add((Object)new ItemStack((ItemLike)Items.STONE));
            }
            return this.create(windowId, inv, CorpseEntity.createFromDeath(inv.player, death), inv.player.getAbilities().instabuild, isHistory);
        }
        UUID uuid = buffer.readUUID();
        AABB aabb = inv.player.getBoundingBox();
        aabb = aabb.inflate(10.0);
        Optional<CorpseEntity> entity = inv.player.level().getEntitiesOfClass(CorpseEntity.class, aabb).stream().filter(corpse -> corpse.getUUID().equals(uuid) && corpse.distanceTo((Entity)inv.player) <= 5.0f).findFirst();
        return (T)((Object)((CorpseContainerBase)entity.map(corpseEntity -> {
            if (!additionalItemsEmpty) {
                corpseEntity.getDeath().getAdditionalItems().add((Object)new ItemStack((ItemLike)Items.STONE));
            }
            return this.create(windowId, inv.player.getInventory(), (CorpseEntity)((Object)corpseEntity), true, isHistory);
        }).orElse(null)));
    }

    public abstract T create(int var1, Inventory var2, CorpseEntity var3, boolean var4, boolean var5);
}

